/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.event;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.base.VerifyException;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.reflect.TypeToken;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.velocitypowered.api.event.Continuation;
import com.velocitypowered.api.event.EventHandler;
import com.velocitypowered.api.event.EventManager;
import com.velocitypowered.api.event.EventTask;
import com.velocitypowered.api.event.PostOrder;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.plugin.PluginContainer;
import com.velocitypowered.api.plugin.PluginManager;
import com.velocitypowered.proxy.event.CustomHandlerAdapter;
import com.velocitypowered.proxy.event.EventTypeTracker;
import com.velocitypowered.proxy.event.UntargetedEventHandler;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.lanternpowered.lmbda.LambdaFactory;
import org.lanternpowered.lmbda.LambdaType;

public class VelocityEventManager
implements EventManager {
    private static final Logger logger = LogManager.getLogger(VelocityEventManager.class);
    private static final MethodHandles.Lookup methodHandlesLookup = MethodHandles.lookup();
    private static final LambdaType<UntargetedEventHandler.EventTaskHandler> untargetedEventTaskHandlerType = LambdaType.of(UntargetedEventHandler.EventTaskHandler.class);
    private static final LambdaType<UntargetedEventHandler.VoidHandler> untargetedVoidHandlerType = LambdaType.of(UntargetedEventHandler.VoidHandler.class);
    private static final LambdaType<UntargetedEventHandler.WithContinuationHandler> untargetedWithContinuationHandlerType = LambdaType.of(UntargetedEventHandler.WithContinuationHandler.class);
    private static final Comparator<HandlerRegistration> handlerComparator = Comparator.comparingInt(o -> o.order);
    private final ExecutorService asyncExecutor;
    private final PluginManager pluginManager;
    private final ListMultimap<Class<?>, HandlerRegistration> handlersByType = ArrayListMultimap.create();
    private final LoadingCache<Class<?>, HandlersCache> handlersCache = Caffeine.newBuilder().build(this::bakeHandlers);
    private final LoadingCache<Method, UntargetedEventHandler> untargetedMethodHandlers = Caffeine.newBuilder().weakValues().build(this::buildUntargetedMethodHandler);
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final List<CustomHandlerAdapter<?>> handlerAdapters = new ArrayList();
    private final EventTypeTracker eventTypeTracker = new EventTypeTracker();
    private static final int TASK_STATE_DEFAULT = 0;
    private static final int TASK_STATE_EXECUTING = 1;
    private static final int TASK_STATE_CONTINUE_IMMEDIATELY = 2;
    private static final VarHandle CONTINUATION_TASK_RESUMED;
    private static final VarHandle CONTINUATION_TASK_STATE;

    public VelocityEventManager(PluginManager pluginManager) {
        this.pluginManager = pluginManager;
        this.asyncExecutor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), new ThreadFactoryBuilder().setNameFormat("Velocity Async Event Executor - #%d").setDaemon(true).build());
    }

    public <F> void registerHandlerAdapter(String name, Predicate<Method> filter, BiConsumer<Method, List<String>> validator, TypeToken<F> invokeFunctionType, Function<F, BiFunction<Object, Object, EventTask>> handlerBuilder) {
        this.handlerAdapters.add(new CustomHandlerAdapter<F>(name, filter, validator, invokeFunctionType, handlerBuilder, methodHandlesLookup));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private @Nullable HandlersCache bakeHandlers(Class<?> eventType) {
        ArrayList<HandlerRegistration> baked = new ArrayList<HandlerRegistration>();
        Collection<Class<?>> types = this.eventTypeTracker.getFriendsOf(eventType);
        this.lock.readLock().lock();
        try {
            for (Class<?> type : types) {
                baked.addAll(this.handlersByType.get((Object)type));
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (baked.isEmpty()) {
            return null;
        }
        baked.sort(handlerComparator);
        return new HandlersCache(baked.toArray(new HandlerRegistration[0]));
    }

    private UntargetedEventHandler buildUntargetedMethodHandler(Method method) throws IllegalAccessException {
        for (CustomHandlerAdapter<?> handlerAdapter : this.handlerAdapters) {
            if (!handlerAdapter.filter.test(method)) continue;
            return handlerAdapter.buildUntargetedHandler(method);
        }
        MethodHandles.Lookup lookup = MethodHandles.privateLookupIn(method.getDeclaringClass(), methodHandlesLookup);
        MethodHandle methodHandle = lookup.unreflect(method);
        LambdaType<UntargetedEventHandler> type = EventTask.class.isAssignableFrom(method.getReturnType()) ? untargetedEventTaskHandlerType : (method.getParameterCount() == 2 ? untargetedWithContinuationHandlerType : untargetedVoidHandlerType);
        return LambdaFactory.create(type.defineClassesWith(lookup), methodHandle);
    }

    private void collectMethods(Class<?> targetClass, Map<String, MethodHandlerInfo> collected) {
        for (Method method : targetClass.getDeclaredMethods()) {
            Subscribe subscribe = method.getAnnotation(Subscribe.class);
            if (subscribe == null) continue;
            String key = method.getName() + "(" + Arrays.stream(method.getParameterTypes()).map(Class::getName).collect(Collectors.joining(",")) + ")";
            if (Modifier.isPrivate(method.getModifiers())) {
                key = targetClass.getName() + "$" + key;
            }
            if (collected.containsKey(key)) continue;
            HashSet<String> errors = new HashSet<String>();
            if (Modifier.isStatic(method.getModifiers())) {
                errors.add("method must not be static");
            }
            if (Modifier.isAbstract(method.getModifiers())) {
                errors.add("method must not be abstract");
            }
            Class<?> eventType = null;
            Class<?> continuationType = null;
            CustomHandlerAdapter<?> handlerAdapter = null;
            int paramCount = method.getParameterCount();
            if (paramCount == 0) {
                errors.add("method must have at least one parameter which is the event");
            } else {
                Class<?>[] parameterTypes = method.getParameterTypes();
                eventType = parameterTypes[0];
                for (CustomHandlerAdapter<?> handlerAdapterCandidate : this.handlerAdapters) {
                    if (!handlerAdapterCandidate.filter.test(method)) continue;
                    handlerAdapter = handlerAdapterCandidate;
                    break;
                }
                if (handlerAdapter != null) {
                    ArrayList adapterErrors = new ArrayList();
                    handlerAdapter.validator.accept(method, adapterErrors);
                    if (!adapterErrors.isEmpty()) {
                        errors.add(String.format("%s adapter errors: [%s]", handlerAdapter.name, String.join((CharSequence)", ", adapterErrors)));
                    }
                } else if (paramCount == 2 && (continuationType = parameterTypes[1]) != Continuation.class) {
                    errors.add(String.format("method is allowed to have a continuation as second parameter, but %s is invalid", continuationType.getName()));
                }
            }
            if (handlerAdapter == null) {
                Class<?> returnType = method.getReturnType();
                if (returnType != Void.TYPE && continuationType == Continuation.class) {
                    errors.add("method return type must be void if a continuation parameter is provided");
                } else if (returnType != Void.TYPE && returnType != EventTask.class) {
                    errors.add("method return type must be void, AsyncTask, AsyncTask.Basic or AsyncTask.WithContinuation");
                }
            }
            short order = (short)subscribe.order().ordinal();
            String errorsJoined = errors.isEmpty() ? null : String.join((CharSequence)",", errors);
            collected.put(key, new MethodHandlerInfo(method, eventType, order, errorsJoined, continuationType));
        }
        Class<?> superclass = targetClass.getSuperclass();
        if (superclass != Object.class) {
            this.collectMethods(superclass, collected);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void register(List<HandlerRegistration> registrations) {
        this.lock.writeLock().lock();
        try {
            for (HandlerRegistration registration2 : registrations) {
                this.handlersByType.put(registration2.eventType, registration2);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        this.handlersCache.invalidateAll(registrations.stream().flatMap(registration -> this.eventTypeTracker.getFriendsOf(registration.eventType).stream()).distinct().collect(Collectors.toList()));
    }

    @Override
    public void register(Object plugin, Object listener) {
        Objects.requireNonNull(listener, "listener");
        PluginContainer pluginContainer = this.pluginManager.ensurePluginContainer(plugin);
        if (plugin == listener) {
            throw new IllegalArgumentException("The plugin main instance is automatically registered.");
        }
        this.registerInternally(pluginContainer, listener);
    }

    @Override
    public <E> void register(Object plugin, Class<E> eventClass, PostOrder order, EventHandler<E> handler) {
        PluginContainer pluginContainer = this.pluginManager.ensurePluginContainer(plugin);
        Objects.requireNonNull(eventClass, "eventClass");
        Objects.requireNonNull(handler, "handler");
        HandlerRegistration registration = new HandlerRegistration(pluginContainer, (short)order.ordinal(), eventClass, handler, handler);
        this.register(Collections.singletonList(registration));
    }

    public void registerInternally(PluginContainer pluginContainer, Object listener) {
        Class<?> targetClass = listener.getClass();
        HashMap<String, MethodHandlerInfo> collected = new HashMap<String, MethodHandlerInfo>();
        this.collectMethods(targetClass, collected);
        ArrayList<HandlerRegistration> registrations = new ArrayList<HandlerRegistration>();
        for (MethodHandlerInfo info : collected.values()) {
            if (info.errors != null) {
                logger.info("Invalid listener method {} in {}: {}", (Object)info.method.getName(), (Object)info.method.getDeclaringClass().getName(), (Object)info.errors);
                continue;
            }
            UntargetedEventHandler untargetedHandler = this.untargetedMethodHandlers.get(info.method);
            assert (untargetedHandler != null);
            if (info.eventType == null) {
                throw new VerifyException("Event type is not present and there are no errors");
            }
            EventHandler<Object> handler = untargetedHandler.buildHandler(listener);
            registrations.add(new HandlerRegistration(pluginContainer, info.order, info.eventType, listener, handler));
        }
        this.register(registrations);
    }

    @Override
    public void unregisterListeners(Object plugin) {
        PluginContainer pluginContainer = this.pluginManager.ensurePluginContainer(plugin);
        this.unregisterIf(registration -> registration.plugin == pluginContainer);
    }

    @Override
    public void unregisterListener(Object plugin, Object handler) {
        PluginContainer pluginContainer = this.pluginManager.ensurePluginContainer(plugin);
        Objects.requireNonNull(handler, "handler");
        this.unregisterIf(registration -> registration.plugin == pluginContainer && registration.instance == handler);
    }

    @Override
    public <E> void unregister(Object plugin, EventHandler<E> handler) {
        this.unregisterListener(plugin, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterIf(Predicate<HandlerRegistration> predicate) {
        ArrayList<HandlerRegistration> removed = new ArrayList<HandlerRegistration>();
        this.lock.writeLock().lock();
        try {
            Iterator it = this.handlersByType.values().iterator();
            while (it.hasNext()) {
                HandlerRegistration registration2 = (HandlerRegistration)it.next();
                if (!predicate.test(registration2)) continue;
                it.remove();
                removed.add(registration2);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        this.handlersCache.invalidateAll(removed.stream().flatMap(registration -> this.eventTypeTracker.getFriendsOf(registration.eventType).stream()).distinct().collect(Collectors.toList()));
    }

    public boolean hasSubscribers(Class<?> eventClass) {
        Objects.requireNonNull(eventClass, "eventClass");
        HandlersCache handlersCache = this.handlersCache.get(eventClass);
        return handlersCache != null && handlersCache.handlers.length > 0;
    }

    @Override
    public void fireAndForget(Object event) {
        Objects.requireNonNull(event, "event");
        HandlersCache handlersCache = this.handlersCache.get(event.getClass());
        if (handlersCache == null || handlersCache.handlers.length == 0) {
            return;
        }
        this.fire(null, event, handlersCache);
    }

    @Override
    public <E> CompletableFuture<E> fire(E event) {
        Objects.requireNonNull(event, "event");
        HandlersCache handlersCache = this.handlersCache.get(event.getClass());
        if (handlersCache == null || handlersCache.handlers.length == 0) {
            return CompletableFuture.completedFuture(event);
        }
        CompletableFuture future = new CompletableFuture();
        this.fire(future, event, handlersCache);
        return future;
    }

    private <E> void fire(@Nullable CompletableFuture<E> future, E event, HandlersCache handlersCache) {
        this.asyncExecutor.execute(() -> this.fire(future, event, 0, true, handlersCache.handlers));
    }

    private <E> void fire(@Nullable CompletableFuture<E> future, E event, int offset, boolean currentlyAsync, HandlerRegistration[] registrations) {
        for (int i = offset; i < registrations.length; ++i) {
            HandlerRegistration registration = registrations[i];
            try {
                EventTask eventTask = registration.handler.executeAsync(event);
                if (eventTask == null) continue;
                ContinuationTask<E> continuationTask = new ContinuationTask<E>(eventTask, registrations, future, event, i, currentlyAsync);
                if (currentlyAsync || !eventTask.requiresAsync()) {
                    if (continuationTask.execute()) {
                        continue;
                    }
                } else {
                    this.asyncExecutor.execute(continuationTask);
                }
                return;
            }
            catch (Throwable t) {
                VelocityEventManager.logHandlerException(registration, t);
            }
        }
        if (future != null) {
            future.complete(event);
        }
    }

    private static void logHandlerException(HandlerRegistration registration, Throwable t) {
        logger.error("Couldn't pass {} to {}", (Object)registration.eventType.getSimpleName(), (Object)registration.plugin.getDescription().getId(), (Object)t);
    }

    public boolean shutdown() throws InterruptedException {
        this.asyncExecutor.shutdown();
        return this.asyncExecutor.awaitTermination(10L, TimeUnit.SECONDS);
    }

    public ExecutorService getAsyncExecutor() {
        return this.asyncExecutor;
    }

    static {
        try {
            CONTINUATION_TASK_RESUMED = MethodHandles.lookup().findVarHandle(ContinuationTask.class, "resumed", Boolean.TYPE);
            CONTINUATION_TASK_STATE = MethodHandles.lookup().findVarHandle(ContinuationTask.class, "state", Integer.TYPE);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException();
        }
    }

    final class ContinuationTask<E>
    implements Continuation,
    Runnable {
        private final EventTask task;
        private final int index;
        private final HandlerRegistration[] registrations;
        private final @Nullable CompletableFuture<E> future;
        private final boolean currentlyAsync;
        private final E event;
        private volatile int state = 0;
        private volatile boolean resumed = false;

        private ContinuationTask(EventTask task, HandlerRegistration @Nullable [] registrations, CompletableFuture<E> future, E event, int index, boolean currentlyAsync) {
            this.task = task;
            this.registrations = registrations;
            this.future = future;
            this.event = event;
            this.index = index;
            this.currentlyAsync = currentlyAsync;
        }

        @Override
        public void run() {
            if (this.execute()) {
                VelocityEventManager.this.fire(this.future, this.event, this.index + 1, this.currentlyAsync, this.registrations);
            }
        }

        boolean execute() {
            this.state = 1;
            try {
                this.task.execute(this);
            }
            catch (Throwable t) {
                this.resume(t, false);
            }
            return !CONTINUATION_TASK_STATE.compareAndSet(this, 1, 0);
        }

        @Override
        public void resume() {
            this.resume(null, true);
        }

        void resume(@Nullable Throwable exception, boolean validateOnlyOnce) {
            boolean changed = CONTINUATION_TASK_RESUMED.compareAndSet(this, false, true);
            if (!changed && validateOnlyOnce) {
                throw new IllegalStateException("The continuation can only be resumed once.");
            }
            HandlerRegistration registration = this.registrations[this.index];
            if (exception != null) {
                VelocityEventManager.logHandlerException(registration, exception);
            }
            if (!changed) {
                return;
            }
            if (this.index + 1 == this.registrations.length) {
                if (this.future != null) {
                    this.future.complete(this.event);
                }
                return;
            }
            if (!CONTINUATION_TASK_STATE.compareAndSet(this, 1, 2)) {
                VelocityEventManager.this.asyncExecutor.execute(() -> VelocityEventManager.this.fire(this.future, this.event, this.index + 1, true, this.registrations));
            }
        }

        @Override
        public void resumeWithException(Throwable exception) {
            this.resume(Objects.requireNonNull(exception, "exception"), true);
        }
    }

    static final class MethodHandlerInfo {
        final Method method;
        final @Nullable Class<?> eventType;
        final short order;
        final @Nullable String errors;
        final @Nullable Class<?> continuationType;

        private MethodHandlerInfo(Method method, @Nullable Class<?> eventType, short order, @Nullable String errors, @Nullable Class<?> continuationType) {
            this.method = method;
            this.eventType = eventType;
            this.order = order;
            this.errors = errors;
            this.continuationType = continuationType;
        }
    }

    static final class HandlersCache {
        final HandlerRegistration[] handlers;

        HandlersCache(HandlerRegistration[] handlers) {
            this.handlers = handlers;
        }
    }

    static enum AsyncType {
        ALWAYS,
        NEVER;

    }

    static final class HandlerRegistration {
        final PluginContainer plugin;
        final short order;
        final Class<?> eventType;
        final EventHandler<Object> handler;
        final Object instance;

        public HandlerRegistration(PluginContainer plugin, short order, Class<?> eventType, Object instance, EventHandler<Object> handler) {
            this.plugin = plugin;
            this.order = order;
            this.eventType = eventType;
            this.instance = instance;
            this.handler = handler;
        }
    }
}

