/*
 * Decompiled with CFR 0.152.
 */
package ninja.leaping.configurate.loader;

import java.io.BufferedWriter;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadLocalRandom;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class AtomicFiles {
    private AtomicFiles() {
    }

    public static @NonNull Callable<BufferedWriter> createAtomicWriterFactory(@NonNull Path path, @NonNull Charset charset) {
        Objects.requireNonNull(path, "path");
        return () -> AtomicFiles.createAtomicBufferedWriter(path, charset);
    }

    public static @NonNull BufferedWriter createAtomicBufferedWriter(@NonNull Path path, @NonNull Charset charset) throws IOException {
        path = path.toAbsolutePath();
        try {
            while (Files.isSymbolicLink(path)) {
                path = Files.readSymbolicLink(path);
            }
        }
        catch (IOException | UnsupportedOperationException exception) {
            // empty catch block
        }
        Path writePath = AtomicFiles.getTemporaryPath(path.getParent(), path.getFileName().toString());
        if (Files.exists(path, new LinkOption[0])) {
            Files.copy(path, writePath, StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
        }
        BufferedWriter output = Files.newBufferedWriter(writePath, charset, new OpenOption[0]);
        return new BufferedWriter(new AtomicFileWriter(writePath, path, output));
    }

    private static @NonNull Path getTemporaryPath(@NonNull Path parent, @NonNull String key) {
        String fileName = System.nanoTime() + (long)ThreadLocalRandom.current().nextInt() + Objects.requireNonNull(key, "key").replaceAll("\\\\|/|:", "-") + ".tmp";
        return parent.resolve(fileName);
    }

    private static class AtomicFileWriter
    extends FilterWriter {
        private final Path targetPath;
        private final Path writePath;

        protected AtomicFileWriter(Path writePath, Path targetPath, Writer wrapping) {
            super(wrapping);
            this.writePath = writePath;
            this.targetPath = targetPath;
        }

        @Override
        public void close() throws IOException {
            super.close();
            Files.createDirectories(this.targetPath.getParent(), new FileAttribute[0]);
            Files.move(this.writePath, this.targetPath, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
    }
}

