/*
 * Decompiled with CFR 0.152.
 */
package ninja.leaping.configurate.objectmapping.serialize;

import com.google.common.reflect.TypeToken;
import java.lang.reflect.Modifier;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.objectmapping.ObjectMapper;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import ninja.leaping.configurate.objectmapping.serialize.TypeSerializer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

class AnnotatedObjectSerializer
implements TypeSerializer<Object> {
    public static final String CLASS_KEY = "__class__";

    AnnotatedObjectSerializer() {
    }

    @Override
    public Object deserialize(@NonNull TypeToken<?> type, @NonNull ConfigurationNode value) throws ObjectMappingException {
        TypeToken<?> clazz = this.getInstantiableType(type, value.getNode(CLASS_KEY).getString());
        return value.getOptions().getObjectMapperFactory().getMapper(clazz).bindToNew().populate(value);
    }

    private TypeToken<?> getInstantiableType(TypeToken<?> type, String configuredName) throws ObjectMappingException {
        TypeToken<?> retClass;
        Class<?> rawType = type.getRawType();
        if (rawType.isInterface() || Modifier.isAbstract(rawType.getModifiers())) {
            if (configuredName == null) {
                throw new ObjectMappingException("No available configured type for instances of " + type);
            }
            try {
                retClass = TypeToken.of(Class.forName(configuredName));
            }
            catch (ClassNotFoundException e) {
                throw new ObjectMappingException("Unknown class of object " + configuredName, e);
            }
            if (!retClass.isSubtypeOf(type)) {
                throw new ObjectMappingException("Configured type " + configuredName + " does not extend " + rawType.getCanonicalName());
            }
        } else {
            retClass = type;
        }
        return retClass;
    }

    @Override
    public void serialize(@NonNull TypeToken<?> type, @Nullable Object obj, @NonNull ConfigurationNode value) throws ObjectMappingException {
        ObjectMapper<?> mapper;
        if (obj == null) {
            ConfigurationNode clazz = value.getNode(CLASS_KEY);
            value.setValue(null);
            if (!clazz.isVirtual()) {
                value.getNode(CLASS_KEY).setValue(clazz);
            }
            return;
        }
        Class<?> rawType = type.getRawType();
        if (rawType.isInterface() || Modifier.isAbstract(rawType.getModifiers())) {
            value.getNode(CLASS_KEY).setValue(obj.getClass().getName());
            mapper = value.getOptions().getObjectMapperFactory().getMapper(obj.getClass());
        } else {
            mapper = value.getOptions().getObjectMapperFactory().getMapper(type);
        }
        mapper.bind(obj).serialize(value);
    }
}

