/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy;

import com.velocitypowered.proxy.ProxyOptions;
import com.velocitypowered.proxy.VelocityServer;
import io.netty.util.ResourceLeakDetector;
import java.text.DecimalFormat;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Velocity {
    private static final Logger logger;

    public static void main(String ... args) {
        ProxyOptions options = new ProxyOptions(args);
        if (options.isHelp()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        VelocityServer server = new VelocityServer(options);
        server.start();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> server.shutdown(false), "Shutdown thread"));
        double bootTime = (double)(System.currentTimeMillis() - startTime) / 1000.0;
        logger.info("Done ({}s)!", (Object)new DecimalFormat("#.##").format(bootTime));
        server.getConsoleCommandSource().start();
        server.awaitProxyShutdown();
    }

    static {
        System.setProperty("java.util.logging.manager", "org.apache.logging.log4j.jul.LogManager");
        logger = LogManager.getLogger(Velocity.class);
        System.setProperty("java.awt.headless", "true");
        if (System.getProperty("velocity.natives-tmpdir") != null) {
            System.setProperty("io.netty.native.workdir", System.getProperty("velocity.natives-tmpdir"));
        }
        if (System.getProperty("io.netty.leakDetection.level") == null) {
            ResourceLeakDetector.setLevel(ResourceLeakDetector.Level.DISABLED);
        }
    }
}

