/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.connection.client;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.suggestion.Suggestion;
import com.velocitypowered.api.command.VelocityBrigadierMessage;
import com.velocitypowered.api.event.command.CommandExecuteEvent;
import com.velocitypowered.api.event.connection.PluginMessageEvent;
import com.velocitypowered.api.event.player.PlayerChannelRegisterEvent;
import com.velocitypowered.api.event.player.PlayerChatEvent;
import com.velocitypowered.api.event.player.PlayerClientBrandEvent;
import com.velocitypowered.api.event.player.TabCompleteEvent;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import com.velocitypowered.api.proxy.messages.LegacyChannelIdentifier;
import com.velocitypowered.api.proxy.messages.MinecraftChannelIdentifier;
import com.velocitypowered.proxy.VelocityServer;
import com.velocitypowered.proxy.connection.ConnectionTypes;
import com.velocitypowered.proxy.connection.MinecraftConnection;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.connection.backend.BackendConnectionPhases;
import com.velocitypowered.proxy.connection.backend.BungeeCordMessageResponder;
import com.velocitypowered.proxy.connection.backend.VelocityServerConnection;
import com.velocitypowered.proxy.connection.client.ConnectedPlayer;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.StateRegistry;
import com.velocitypowered.proxy.protocol.packet.BossBar;
import com.velocitypowered.proxy.protocol.packet.Chat;
import com.velocitypowered.proxy.protocol.packet.ClientSettings;
import com.velocitypowered.proxy.protocol.packet.JoinGame;
import com.velocitypowered.proxy.protocol.packet.KeepAlive;
import com.velocitypowered.proxy.protocol.packet.PluginMessage;
import com.velocitypowered.proxy.protocol.packet.ResourcePackResponse;
import com.velocitypowered.proxy.protocol.packet.Respawn;
import com.velocitypowered.proxy.protocol.packet.TabCompleteRequest;
import com.velocitypowered.proxy.protocol.packet.TabCompleteResponse;
import com.velocitypowered.proxy.protocol.packet.title.GenericTitlePacket;
import com.velocitypowered.proxy.protocol.util.PluginMessageUtil;
import com.velocitypowered.proxy.util.CharacterUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.util.ReferenceCountUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ClientPlaySessionHandler
implements MinecraftSessionHandler {
    private static final Logger logger = LogManager.getLogger(ClientPlaySessionHandler.class);
    private final ConnectedPlayer player;
    private boolean spawned = false;
    private final List<UUID> serverBossBars = new ArrayList<UUID>();
    private final Queue<PluginMessage> loginPluginMessages = new ArrayDeque<PluginMessage>();
    private final VelocityServer server;
    private @Nullable TabCompleteRequest outstandingTabComplete;

    public ClientPlaySessionHandler(VelocityServer server, ConnectedPlayer player) {
        this.player = player;
        this.server = server;
    }

    @Override
    public void activated() {
        Collection<String> channels = this.server.getChannelRegistrar().getChannelsForProtocol(this.player.getProtocolVersion());
        if (!channels.isEmpty()) {
            PluginMessage register = PluginMessageUtil.constructChannelsPacket(this.player.getProtocolVersion(), channels);
            this.player.getConnection().write(register);
            this.player.getKnownChannels().addAll(channels);
        }
    }

    @Override
    public void deactivated() {
        for (PluginMessage message : this.loginPluginMessages) {
            ReferenceCountUtil.release(message);
        }
    }

    @Override
    public boolean handle(KeepAlive packet) {
        MinecraftConnection smc;
        Long sentTime;
        VelocityServerConnection serverConnection = this.player.getConnectedServer();
        if (serverConnection != null && (sentTime = serverConnection.getPendingPings().remove(packet.getRandomId())) != null && (smc = serverConnection.getConnection()) != null) {
            this.player.setPing(System.currentTimeMillis() - sentTime);
            smc.write(packet);
        }
        return true;
    }

    @Override
    public boolean handle(ClientSettings packet) {
        this.player.setPlayerSettings(packet);
        return false;
    }

    @Override
    public boolean handle(Chat packet) {
        VelocityServerConnection serverConnection = this.player.getConnectedServer();
        if (serverConnection == null) {
            return true;
        }
        MinecraftConnection smc = serverConnection.getConnection();
        if (smc == null) {
            return true;
        }
        String msg = packet.getMessage();
        if (CharacterUtil.containsIllegalCharacters(msg)) {
            this.player.disconnect(Component.translatable("velocity.error.illegal-chat-characters", (TextColor)NamedTextColor.RED));
            return true;
        }
        if (msg.startsWith("/")) {
            String originalCommand = msg.substring(1);
            ((CompletableFuture)((CompletableFuture)this.server.getCommandManager().callCommandEvent(this.player, msg.substring(1)).thenComposeAsync(event -> this.processCommandExecuteResult(originalCommand, event.getResult()))).whenComplete((ignored, throwable) -> {
                if (this.server.getConfiguration().isLogCommandExecutions()) {
                    logger.info("{} -> executed command /{}", (Object)this.player, (Object)originalCommand);
                }
            })).exceptionally(e -> {
                logger.info("Exception occurred while running command for {}", (Object)this.player.getUsername(), e);
                this.player.sendMessage(Component.translatable("velocity.command.generic-error", (TextColor)NamedTextColor.RED));
                return null;
            });
        } else {
            PlayerChatEvent event2 = new PlayerChatEvent(this.player, msg);
            ((CompletableFuture)this.server.getEventManager().fire(event2).thenAcceptAsync(pme -> {
                PlayerChatEvent.ChatResult chatResult = pme.getResult();
                if (chatResult.isAllowed()) {
                    Optional<String> eventMsg = pme.getResult().getMessage();
                    if (eventMsg.isPresent()) {
                        smc.write(Chat.createServerbound(eventMsg.get()));
                    } else {
                        smc.write(packet);
                    }
                }
            }, (Executor)smc.eventLoop())).exceptionally(ex -> {
                logger.error("Exception while handling player chat for {}", (Object)this.player, ex);
                return null;
            });
        }
        return true;
    }

    @Override
    public boolean handle(TabCompleteRequest packet) {
        boolean isCommand;
        boolean bl = isCommand = !packet.isAssumeCommand() && packet.getCommand().startsWith("/");
        if (isCommand) {
            return this.handleCommandTabComplete(packet);
        }
        return this.handleRegularTabComplete(packet);
    }

    @Override
    public boolean handle(PluginMessage packet) {
        MinecraftConnection backendConn;
        VelocityServerConnection serverConn = this.player.getConnectedServer();
        MinecraftConnection minecraftConnection = backendConn = serverConn != null ? serverConn.getConnection() : null;
        if (serverConn != null && backendConn != null) {
            if (backendConn.getState() != StateRegistry.PLAY) {
                logger.warn("A plugin message was received while the backend server was not ready. Channel: {}. Packet discarded.", (Object)packet.getChannel());
            } else if (PluginMessageUtil.isRegister(packet)) {
                List<String> channels = PluginMessageUtil.getChannels(packet);
                this.player.getKnownChannels().addAll(channels);
                ArrayList<ChannelIdentifier> channelIdentifiers = new ArrayList<ChannelIdentifier>();
                for (String channel : channels) {
                    try {
                        channelIdentifiers.add(MinecraftChannelIdentifier.from(channel));
                    }
                    catch (IllegalArgumentException e) {
                        channelIdentifiers.add(new LegacyChannelIdentifier(channel));
                    }
                }
                this.server.getEventManager().fireAndForget(new PlayerChannelRegisterEvent(this.player, ImmutableList.copyOf(channelIdentifiers)));
                backendConn.write(packet.retain());
            } else if (PluginMessageUtil.isUnregister(packet)) {
                this.player.getKnownChannels().removeAll(PluginMessageUtil.getChannels(packet));
                backendConn.write(packet.retain());
            } else if (PluginMessageUtil.isMcBrand(packet)) {
                String brand = PluginMessageUtil.readBrandMessage(packet.content());
                this.server.getEventManager().fireAndForget(new PlayerClientBrandEvent(this.player, brand));
                this.player.setClientBrand(brand);
                backendConn.write(PluginMessageUtil.rewriteMinecraftBrand(packet, this.server.getVersion(), this.player.getProtocolVersion()));
            } else {
                if (BungeeCordMessageResponder.isBungeeCordMessage(packet)) {
                    return true;
                }
                if (serverConn.getPhase() == BackendConnectionPhases.IN_TRANSITION) {
                    VelocityServerConnection inFlight = this.player.getConnectionInFlight();
                    if (inFlight != null) {
                        this.player.getPhase().handle(this.player, packet, inFlight);
                    }
                    return true;
                }
                if (!this.player.getPhase().handle(this.player, packet, serverConn)) {
                    if (!this.player.getPhase().consideredComplete() || !serverConn.getPhase().consideredComplete()) {
                        this.loginPluginMessages.add(packet.retain());
                    } else {
                        ChannelIdentifier id = this.server.getChannelRegistrar().getFromId(packet.getChannel());
                        if (id == null) {
                            backendConn.write(packet.retain());
                        } else {
                            byte[] copy = ByteBufUtil.getBytes(packet.content());
                            PluginMessageEvent event = new PluginMessageEvent(this.player, serverConn, id, copy);
                            ((CompletableFuture)this.server.getEventManager().fire(event).thenAcceptAsync(pme -> {
                                if (pme.getResult().isAllowed()) {
                                    PluginMessage message = new PluginMessage(packet.getChannel(), Unpooled.wrappedBuffer(copy));
                                    backendConn.write(message);
                                }
                            }, (Executor)backendConn.eventLoop())).exceptionally(ex -> {
                                logger.error("Exception while handling plugin message packet for {}", (Object)this.player, ex);
                                return null;
                            });
                        }
                    }
                }
            }
        }
        return true;
    }

    @Override
    public boolean handle(ResourcePackResponse packet) {
        return this.player.onResourcePackResponse(packet.getStatus());
    }

    @Override
    public void handleGeneric(MinecraftPacket packet) {
        VelocityServerConnection serverConnection = this.player.getConnectedServer();
        if (serverConnection == null) {
            return;
        }
        MinecraftConnection smc = serverConnection.getConnection();
        if (smc != null && serverConnection.getPhase().consideredComplete()) {
            if (packet instanceof PluginMessage) {
                ((PluginMessage)packet).retain();
            }
            smc.write(packet);
        }
    }

    @Override
    public void handleUnknown(ByteBuf buf) {
        VelocityServerConnection serverConnection = this.player.getConnectedServer();
        if (serverConnection == null) {
            return;
        }
        MinecraftConnection smc = serverConnection.getConnection();
        if (smc != null && !smc.isClosed() && serverConnection.getPhase().consideredComplete()) {
            smc.write(buf.retain());
        }
    }

    @Override
    public void disconnected() {
        this.player.teardown();
    }

    @Override
    public void exception(Throwable throwable) {
        this.player.disconnect(Component.translatable("velocity.error.player-connection-error", (TextColor)NamedTextColor.RED));
    }

    @Override
    public void writabilityChanged() {
        MinecraftConnection smc;
        VelocityServerConnection serverConn;
        boolean writable = this.player.getConnection().getChannel().isWritable();
        if (!writable) {
            this.player.getConnection().eventLoop().execute(() -> this.player.getConnection().flush());
        }
        if ((serverConn = this.player.getConnectedServer()) != null && (smc = serverConn.getConnection()) != null) {
            smc.setAutoReading(writable);
        }
    }

    public void handleBackendJoinGame(JoinGame joinGame, VelocityServerConnection destination) {
        PluginMessage pm;
        MinecraftConnection serverMc = destination.ensureConnected();
        if (!this.spawned) {
            this.spawned = true;
            this.player.getConnection().delayedWrite(joinGame);
            this.player.getPhase().onFirstJoin(this.player);
        } else {
            this.player.getTabList().clearAll();
            if (this.player.getConnection().getType() == ConnectionTypes.LEGACY_FORGE) {
                this.doSafeClientServerSwitch(joinGame);
            } else {
                this.doFastClientServerSwitch(joinGame);
            }
        }
        destination.setActiveDimensionRegistry(joinGame.getDimensionRegistry());
        for (UUID serverBossBar : this.serverBossBars) {
            BossBar deletePacket = new BossBar();
            deletePacket.setUuid(serverBossBar);
            deletePacket.setAction(1);
            this.player.getConnection().delayedWrite(deletePacket);
        }
        this.serverBossBars.clear();
        ProtocolVersion serverVersion = serverMc.getProtocolVersion();
        if (!this.player.getKnownChannels().isEmpty()) {
            serverMc.delayedWrite(PluginMessageUtil.constructChannelsPacket(serverVersion, this.player.getKnownChannels()));
        }
        while ((pm = this.loginPluginMessages.poll()) != null) {
            serverMc.delayedWrite(pm);
        }
        if (this.player.getProtocolVersion().compareTo(ProtocolVersion.MINECRAFT_1_8) >= 0) {
            this.player.getConnection().delayedWrite(GenericTitlePacket.constructTitlePacket(GenericTitlePacket.ActionType.RESET, this.player.getProtocolVersion()));
        }
        this.player.getConnection().flush();
        serverMc.flush();
        destination.completeJoin();
    }

    private void doFastClientServerSwitch(JoinGame joinGame) {
        int sentOldDim = joinGame.getDimension();
        if (this.player.getProtocolVersion().compareTo(ProtocolVersion.MINECRAFT_1_16) < 0) {
            joinGame.setDimension(joinGame.getDimension() == 0 ? -1 : 0);
        }
        this.player.getConnection().delayedWrite(joinGame);
        this.player.getConnection().delayedWrite(new Respawn(sentOldDim, joinGame.getPartialHashedSeed(), joinGame.getDifficulty(), joinGame.getGamemode(), joinGame.getLevelType(), false, joinGame.getDimensionInfo(), joinGame.getPreviousGamemode(), joinGame.getCurrentDimensionData()));
    }

    private void doSafeClientServerSwitch(JoinGame joinGame) {
        this.player.getConnection().delayedWrite(joinGame);
        int tempDim = joinGame.getDimension() == 0 ? -1 : 0;
        this.player.getConnection().delayedWrite(new Respawn(tempDim, joinGame.getPartialHashedSeed(), joinGame.getDifficulty(), joinGame.getGamemode(), joinGame.getLevelType(), false, joinGame.getDimensionInfo(), joinGame.getPreviousGamemode(), joinGame.getCurrentDimensionData()));
        this.player.getConnection().delayedWrite(new Respawn(joinGame.getDimension(), joinGame.getPartialHashedSeed(), joinGame.getDifficulty(), joinGame.getGamemode(), joinGame.getLevelType(), false, joinGame.getDimensionInfo(), joinGame.getPreviousGamemode(), joinGame.getCurrentDimensionData()));
    }

    public List<UUID> getServerBossBars() {
        return this.serverBossBars;
    }

    private boolean handleCommandTabComplete(TabCompleteRequest packet) {
        String command = packet.getCommand().substring(1);
        int commandEndPosition = command.indexOf(32);
        if (commandEndPosition == -1) {
            commandEndPosition = command.length();
        }
        String commandLabel = command.substring(0, commandEndPosition);
        if (!this.server.getCommandManager().hasCommand(commandLabel)) {
            if (this.player.getProtocolVersion().compareTo(ProtocolVersion.MINECRAFT_1_13) < 0) {
                this.outstandingTabComplete = packet;
            }
            return false;
        }
        ((CompletableFuture)this.server.getCommandManager().offerBrigadierSuggestions(this.player, command).thenAcceptAsync(suggestions -> {
            if (suggestions.isEmpty()) {
                return;
            }
            ArrayList<TabCompleteResponse.Offer> offers = new ArrayList<TabCompleteResponse.Offer>();
            for (Suggestion suggestion : suggestions.getList()) {
                String offer = suggestion.getText();
                Component tooltip = null;
                if (suggestion.getTooltip() != null && suggestion.getTooltip() instanceof VelocityBrigadierMessage) {
                    tooltip = ((VelocityBrigadierMessage)suggestion.getTooltip()).asComponent();
                }
                offers.add(new TabCompleteResponse.Offer(offer, tooltip));
            }
            int startPos = packet.getCommand().lastIndexOf(32) + 1;
            if (startPos > 0) {
                TabCompleteResponse resp = new TabCompleteResponse();
                resp.setTransactionId(packet.getTransactionId());
                resp.setStart(startPos);
                resp.setLength(packet.getCommand().length() - startPos);
                resp.getOffers().addAll(offers);
                this.player.getConnection().write(resp);
            }
        }, (Executor)this.player.getConnection().eventLoop())).exceptionally(ex -> {
            logger.error("Exception while handling command tab completion for player {} executing {}", (Object)this.player, (Object)command, ex);
            return null;
        });
        return true;
    }

    private boolean handleRegularTabComplete(TabCompleteRequest packet) {
        if (this.player.getProtocolVersion().compareTo(ProtocolVersion.MINECRAFT_1_13) < 0) {
            this.outstandingTabComplete = packet;
        }
        return false;
    }

    public void handleTabCompleteResponse(TabCompleteResponse response) {
        if (this.outstandingTabComplete != null && !this.outstandingTabComplete.isAssumeCommand()) {
            if (this.outstandingTabComplete.getCommand().startsWith("/")) {
                this.finishCommandTabComplete(this.outstandingTabComplete, response);
            } else {
                this.finishRegularTabComplete(this.outstandingTabComplete, response);
            }
            this.outstandingTabComplete = null;
        } else {
            this.player.getConnection().write(response);
        }
    }

    private void finishCommandTabComplete(TabCompleteRequest request, TabCompleteResponse response) {
        String command = request.getCommand().substring(1);
        ((CompletableFuture)this.server.getCommandManager().offerBrigadierSuggestions(this.player, command).thenAcceptAsync(offers -> {
            boolean legacy = this.player.getProtocolVersion().compareTo(ProtocolVersion.MINECRAFT_1_13) < 0;
            try {
                for (Suggestion suggestion : offers.getList()) {
                    String offer = suggestion.getText();
                    String string = offer = legacy && !offer.startsWith("/") ? "/" + offer : offer;
                    if (legacy && offer.startsWith(command)) {
                        offer = offer.substring(command.length());
                    }
                    Component tooltip = null;
                    if (suggestion.getTooltip() != null && suggestion.getTooltip() instanceof VelocityBrigadierMessage) {
                        tooltip = ((VelocityBrigadierMessage)suggestion.getTooltip()).asComponent();
                    }
                    response.getOffers().add(new TabCompleteResponse.Offer(offer, tooltip));
                }
                response.getOffers().sort(null);
                this.player.getConnection().write(response);
            }
            catch (Exception e) {
                logger.error("Unable to provide tab list completions for {} for command '{}'", (Object)this.player.getUsername(), (Object)command, (Object)e);
            }
        }, (Executor)this.player.getConnection().eventLoop())).exceptionally(ex -> {
            logger.error("Exception while finishing command tab completion, with request {} and response {}", (Object)request, (Object)response, ex);
            return null;
        });
    }

    private void finishRegularTabComplete(TabCompleteRequest request, TabCompleteResponse response) {
        ArrayList<String> offers = new ArrayList<String>();
        for (TabCompleteResponse.Offer offer : response.getOffers()) {
            offers.add(offer.getText());
        }
        ((CompletableFuture)this.server.getEventManager().fire(new TabCompleteEvent(this.player, request.getCommand(), offers)).thenAcceptAsync(e -> {
            response.getOffers().clear();
            for (String s : e.getSuggestions()) {
                response.getOffers().add(new TabCompleteResponse.Offer(s));
            }
            this.player.getConnection().write(response);
        }, (Executor)this.player.getConnection().eventLoop())).exceptionally(ex -> {
            logger.error("Exception while finishing regular tab completion, with request {} and response{}", (Object)request, (Object)response, ex);
            return null;
        });
    }

    private CompletableFuture<Void> processCommandExecuteResult(String originalCommand, CommandExecuteEvent.CommandResult result) {
        if (result == CommandExecuteEvent.CommandResult.denied()) {
            return CompletableFuture.completedFuture(null);
        }
        MinecraftConnection smc = this.player.ensureAndGetCurrentServer().ensureConnected();
        String commandToRun = result.getCommand().orElse(originalCommand);
        if (result.isForwardToServer()) {
            return CompletableFuture.runAsync(() -> smc.write(Chat.createServerbound("/" + commandToRun)), smc.eventLoop());
        }
        return this.server.getCommandManager().executeImmediatelyAsync(this.player, commandToRun).thenAcceptAsync(hasRun -> {
            if (!hasRun.booleanValue()) {
                smc.write(Chat.createServerbound("/" + commandToRun));
            }
        }, (Executor)smc.eventLoop());
    }

    public void flushQueuedMessages() {
        MinecraftConnection connection;
        VelocityServerConnection serverConnection = this.player.getConnectedServer();
        if (serverConnection != null && (connection = serverConnection.getConnection()) != null) {
            PluginMessage pm;
            while ((pm = this.loginPluginMessages.poll()) != null) {
                connection.write(pm);
            }
        }
    }
}

