/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.connection.client;

import com.google.common.collect.ImmutableList;
import com.spotify.futures.CompletableFutures;
import com.velocitypowered.api.event.proxy.ProxyPingEvent;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.api.proxy.InboundConnection;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import com.velocitypowered.api.proxy.server.ServerPing;
import com.velocitypowered.api.util.ModInfo;
import com.velocitypowered.proxy.VelocityServer;
import com.velocitypowered.proxy.config.PingPassthroughMode;
import com.velocitypowered.proxy.config.VelocityConfiguration;
import com.velocitypowered.proxy.connection.MinecraftConnection;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.protocol.packet.LegacyDisconnect;
import com.velocitypowered.proxy.protocol.packet.LegacyPing;
import com.velocitypowered.proxy.protocol.packet.StatusPing;
import com.velocitypowered.proxy.protocol.packet.StatusRequest;
import com.velocitypowered.proxy.protocol.packet.StatusResponse;
import com.velocitypowered.proxy.server.VelocityRegisteredServer;
import com.velocitypowered.proxy.util.except.QuietRuntimeException;
import io.netty.buffer.ByteBuf;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StatusSessionHandler
implements MinecraftSessionHandler {
    private static final Logger logger = LogManager.getLogger(StatusSessionHandler.class);
    private static final QuietRuntimeException EXPECTED_AWAITING_REQUEST = new QuietRuntimeException("Expected connection to be awaiting status request");
    private final VelocityServer server;
    private final MinecraftConnection connection;
    private final InboundConnection inbound;
    private boolean pingReceived = false;

    StatusSessionHandler(VelocityServer server, MinecraftConnection connection, InboundConnection inbound) {
        this.server = server;
        this.connection = connection;
        this.inbound = inbound;
    }

    @Override
    public void activated() {
        if (this.server.getConfiguration().isShowPingRequests()) {
            logger.info("{} is pinging the server with version {}", (Object)this.inbound, (Object)this.connection.getProtocolVersion());
        }
    }

    private ServerPing constructLocalPing(ProtocolVersion version) {
        VelocityConfiguration configuration = this.server.getConfiguration();
        return new ServerPing(new ServerPing.Version(version.getProtocol(), "Velocity " + ProtocolVersion.SUPPORTED_VERSION_STRING), new ServerPing.Players(this.server.getPlayerCount(), configuration.getShowMaxPlayers(), ImmutableList.of()), configuration.getMotd(), configuration.getFavicon().orElse(null), configuration.isAnnounceForge() ? ModInfo.DEFAULT : null);
    }

    private CompletableFuture<ServerPing> attemptPingPassthrough(PingPassthroughMode mode, List<String> servers, ProtocolVersion pingingVersion) {
        ServerPing fallback = this.constructLocalPing(pingingVersion);
        ArrayList<CompletableFuture<ServerPing>> pings = new ArrayList<CompletableFuture<ServerPing>>();
        for (String s : servers) {
            Optional<RegisteredServer> rs = this.server.getServer(s);
            if (!rs.isPresent()) continue;
            VelocityRegisteredServer vrs = (VelocityRegisteredServer)rs.get();
            pings.add(vrs.ping(this.connection.eventLoop(), pingingVersion));
        }
        if (pings.isEmpty()) {
            return CompletableFuture.completedFuture(fallback);
        }
        CompletableFuture<List<ServerPing>> pingResponses = CompletableFutures.successfulAsList(pings, ex -> fallback);
        switch (mode) {
            case ALL: {
                return pingResponses.thenApply(responses -> {
                    for (ServerPing response : responses) {
                        if (response == fallback) continue;
                        return response;
                    }
                    return fallback;
                });
            }
            case MODS: {
                return pingResponses.thenApply(responses -> {
                    for (ServerPing response : responses) {
                        Optional<ModInfo> modInfo;
                        if (response == fallback || !(modInfo = response.getModinfo()).isPresent()) continue;
                        return fallback.asBuilder().mods(modInfo.get()).build();
                    }
                    return fallback;
                });
            }
            case DESCRIPTION: {
                return pingResponses.thenApply(responses -> {
                    for (ServerPing response : responses) {
                        if (response == fallback || response.getDescriptionComponent() == null) continue;
                        return new ServerPing(fallback.getVersion(), fallback.getPlayers().orElse(null), response.getDescriptionComponent(), fallback.getFavicon().orElse(null), response.getModinfo().orElse(null));
                    }
                    return fallback;
                });
            }
        }
        return CompletableFuture.completedFuture(fallback);
    }

    private CompletableFuture<ServerPing> getInitialPing() {
        VelocityConfiguration configuration = this.server.getConfiguration();
        ProtocolVersion shownVersion = ProtocolVersion.isSupported(this.connection.getProtocolVersion()) ? this.connection.getProtocolVersion() : ProtocolVersion.MAXIMUM_VERSION;
        PingPassthroughMode passthrough = configuration.getPingPassthrough();
        if (passthrough == PingPassthroughMode.DISABLED) {
            return CompletableFuture.completedFuture(this.constructLocalPing(shownVersion));
        }
        String virtualHostStr = this.inbound.getVirtualHost().map(InetSocketAddress::getHostString).map(str -> str.toLowerCase(Locale.ROOT)).orElse("");
        List<String> serversToTry = this.server.getConfiguration().getForcedHosts().getOrDefault(virtualHostStr, this.server.getConfiguration().getAttemptConnectionOrder());
        return this.attemptPingPassthrough(configuration.getPingPassthrough(), serversToTry, shownVersion);
    }

    @Override
    public boolean handle(LegacyPing packet) {
        if (this.pingReceived) {
            throw EXPECTED_AWAITING_REQUEST;
        }
        this.pingReceived = true;
        ((CompletableFuture)((CompletableFuture)this.getInitialPing().thenCompose(ping -> this.server.getEventManager().fire(new ProxyPingEvent(this.inbound, (ServerPing)ping)))).thenAcceptAsync(event -> this.connection.closeWith(LegacyDisconnect.fromServerPing(event.getPing(), packet.getVersion())), (Executor)this.connection.eventLoop())).exceptionally(ex -> {
            logger.error("Exception while handling legacy ping {}", (Object)packet, ex);
            return null;
        });
        return true;
    }

    @Override
    public boolean handle(StatusPing packet) {
        this.connection.closeWith(packet);
        return true;
    }

    @Override
    public boolean handle(StatusRequest packet) {
        if (this.pingReceived) {
            throw EXPECTED_AWAITING_REQUEST;
        }
        this.pingReceived = true;
        ((CompletableFuture)((CompletableFuture)this.getInitialPing().thenCompose(ping -> this.server.getEventManager().fire(new ProxyPingEvent(this.inbound, (ServerPing)ping)))).thenAcceptAsync(event -> {
            StringBuilder json = new StringBuilder();
            VelocityServer.getPingGsonInstance(this.connection.getProtocolVersion()).toJson((Object)event.getPing(), (Appendable)json);
            this.connection.write(new StatusResponse(json));
        }, (Executor)this.connection.eventLoop())).exceptionally(ex -> {
            logger.error("Exception while handling status request {}", (Object)packet, ex);
            return null;
        });
        return true;
    }

    @Override
    public void handleUnknown(ByteBuf buf) {
        this.connection.close(true);
    }

    private static enum State {
        AWAITING_REQUEST,
        RECEIVED_REQUEST;

    }
}

