/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.command.builtin;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.permission.Tristate;
import com.velocitypowered.api.plugin.PluginContainer;
import com.velocitypowered.api.plugin.PluginDescription;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import com.velocitypowered.api.util.ProxyVersion;
import com.velocitypowered.proxy.VelocityServer;
import com.velocitypowered.proxy.util.InformationUtils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;

public class VelocityCommand
implements SimpleCommand {
    private final Map<String, SubCommand> commands;

    public VelocityCommand(VelocityServer server) {
        this.commands = ImmutableMap.builder().put("version", new Info(server)).put("plugins", (Info)((Object)new Plugins(server))).put("reload", (Info)((Object)new Reload(server))).put("dump", (Info)((Object)new Dump(server))).build();
    }

    private void usage(CommandSource source) {
        String availableCommands = this.commands.entrySet().stream().filter(e -> ((SubCommand)e.getValue()).hasPermission(source, new String[0])).map(Map.Entry::getKey).collect(Collectors.joining("|"));
        String commandText = "/velocity <" + availableCommands + ">";
        source.sendMessage(Identity.nil(), (Component)Component.text(commandText, (TextColor)NamedTextColor.RED));
    }

    @Override
    public void execute(SimpleCommand.Invocation invocation) {
        CommandSource source = invocation.source();
        String[] args = (String[])invocation.arguments();
        if (args.length == 0) {
            this.usage(source);
            return;
        }
        SubCommand command = this.commands.get(args[0].toLowerCase(Locale.US));
        if (command == null) {
            this.usage(source);
            return;
        }
        String[] actualArgs = Arrays.copyOfRange(args, 1, args.length);
        command.execute(source, actualArgs);
    }

    @Override
    public List<String> suggest(SimpleCommand.Invocation invocation) {
        CommandSource source = invocation.source();
        String[] currentArgs = (String[])invocation.arguments();
        if (currentArgs.length == 0) {
            return this.commands.entrySet().stream().filter(e -> ((SubCommand)e.getValue()).hasPermission(source, new String[0])).map(Map.Entry::getKey).collect(ImmutableList.toImmutableList());
        }
        if (currentArgs.length == 1) {
            return this.commands.entrySet().stream().filter(e -> ((String)e.getKey()).regionMatches(true, 0, currentArgs[0], 0, currentArgs[0].length())).filter(e -> ((SubCommand)e.getValue()).hasPermission(source, new String[0])).map(Map.Entry::getKey).collect(ImmutableList.toImmutableList());
        }
        SubCommand command = this.commands.get(currentArgs[0].toLowerCase(Locale.US));
        if (command == null) {
            return ImmutableList.of();
        }
        String[] actualArgs = Arrays.copyOfRange(currentArgs, 1, currentArgs.length);
        return command.suggest(source, actualArgs);
    }

    @Override
    public boolean hasPermission(SimpleCommand.Invocation invocation) {
        CommandSource source = invocation.source();
        String[] args = (String[])invocation.arguments();
        if (args.length == 0) {
            return this.commands.values().stream().anyMatch(e -> e.hasPermission(source, args));
        }
        SubCommand command = this.commands.get(args[0].toLowerCase(Locale.US));
        if (command == null) {
            return true;
        }
        String[] actualArgs = Arrays.copyOfRange(args, 1, args.length);
        return command.hasPermission(source, actualArgs);
    }

    private static class Dump
    implements SubCommand {
        private static final Logger logger = LogManager.getLogger(Dump.class);
        private final ProxyServer server;

        private Dump(ProxyServer server) {
            this.server = server;
        }

        @Override
        public void execute(CommandSource source, String @NonNull [] args) {
            if (args.length != 0) {
                source.sendMessage(Component.text("/velocity dump", (TextColor)NamedTextColor.RED));
                return;
            }
            ImmutableSet<RegisteredServer> allServers = ImmutableSet.copyOf(this.server.getAllServers());
            JsonObject servers = new JsonObject();
            for (RegisteredServer iter : allServers) {
                servers.add(iter.getServerInfo().getName(), InformationUtils.collectServerInfo(iter));
            }
            JsonArray connectOrder = new JsonArray();
            ImmutableList<String> attemptedConnectionOrder = ImmutableList.copyOf(this.server.getConfiguration().getAttemptConnectionOrder());
            for (String s : attemptedConnectionOrder) {
                connectOrder.add(s);
            }
            JsonObject proxyConfig = InformationUtils.collectProxyConfig(this.server.getConfiguration());
            proxyConfig.add("servers", servers);
            proxyConfig.add("connectOrder", connectOrder);
            proxyConfig.add("forcedHosts", InformationUtils.collectForcedHosts(this.server.getConfiguration()));
            JsonObject dump = new JsonObject();
            dump.add("versionInfo", InformationUtils.collectProxyInfo(this.server.getVersion()));
            dump.add("platform", InformationUtils.collectEnvironmentInfo());
            dump.add("config", proxyConfig);
            dump.add("plugins", InformationUtils.collectPluginInfo(this.server));
            Path dumpPath = Paths.get("velocity-dump-" + new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss").format(new Date()) + ".json", new String[0]);
            try (BufferedWriter bw = Files.newBufferedWriter(dumpPath, StandardCharsets.UTF_8, StandardOpenOption.CREATE_NEW);){
                bw.write(InformationUtils.toHumanReadableString(dump));
                source.sendMessage(Component.text("An anonymised report containing useful information about this proxy has been saved at " + dumpPath.toAbsolutePath(), (TextColor)NamedTextColor.GREEN));
            }
            catch (IOException e) {
                logger.error("Failed to complete dump command, the executor was interrupted: " + e.getMessage());
                e.printStackTrace();
                source.sendMessage(Component.text("We could not save the anonymized dump. Check the console for more details.", (TextColor)NamedTextColor.RED));
            }
        }

        @Override
        public boolean hasPermission(CommandSource source, String @NonNull [] args) {
            return source.getPermissionValue("velocity.command.plugins") == Tristate.TRUE;
        }
    }

    private static class Plugins
    implements SubCommand {
        private final ProxyServer server;

        private Plugins(ProxyServer server) {
            this.server = server;
        }

        @Override
        public void execute(CommandSource source, String @NonNull [] args) {
            if (args.length != 0) {
                source.sendMessage(Identity.nil(), (Component)Component.text("/velocity plugins", (TextColor)NamedTextColor.RED));
                return;
            }
            ImmutableList<PluginContainer> plugins = ImmutableList.copyOf(this.server.getPluginManager().getPlugins());
            int pluginCount = plugins.size();
            if (pluginCount == 0) {
                source.sendMessage(Component.translatable("velocity.command.no-plugins", (TextColor)NamedTextColor.YELLOW));
                return;
            }
            TextComponent.Builder listBuilder = Component.text();
            for (int i = 0; i < pluginCount; ++i) {
                PluginContainer plugin = (PluginContainer)plugins.get(i);
                listBuilder.append((Component)this.componentForPlugin(plugin.getDescription()));
                if (i + 1 >= pluginCount) continue;
                listBuilder.append((Component)Component.text(", "));
            }
            TranslatableComponent.Builder output = ((TranslatableComponent.Builder)Component.translatable().key("velocity.command.plugins-list").color(NamedTextColor.YELLOW)).args((Component)listBuilder.build());
            source.sendMessage(Identity.nil(), (ComponentLike)output);
        }

        private TextComponent componentForPlugin(PluginDescription description) {
            String pluginInfo = description.getName().orElse(description.getId()) + description.getVersion().map(v -> " " + v).orElse("");
            TextComponent.Builder hoverText = Component.text().content(pluginInfo);
            description.getUrl().ifPresent(url -> {
                hoverText.append((Component)Component.newline());
                hoverText.append((Component)Component.translatable("velocity.command.plugin-tooltip-website", Component.text(url)));
            });
            if (!description.getAuthors().isEmpty()) {
                hoverText.append((Component)Component.newline());
                if (description.getAuthors().size() == 1) {
                    hoverText.append((Component)Component.translatable("velocity.command.plugin-tooltip-author", Component.text(description.getAuthors().get(0))));
                } else {
                    hoverText.append((Component)Component.translatable("velocity.command.plugin-tooltip-author", Component.text(String.join((CharSequence)", ", description.getAuthors()))));
                }
            }
            description.getDescription().ifPresent(pdesc -> {
                hoverText.append((Component)Component.newline());
                hoverText.append((Component)Component.newline());
                hoverText.append((Component)Component.text(pdesc));
            });
            return (TextComponent)Component.text(description.getId(), (TextColor)NamedTextColor.GRAY).hoverEvent(HoverEvent.showText((Component)hoverText.build()));
        }

        @Override
        public boolean hasPermission(CommandSource source, String @NonNull [] args) {
            return source.getPermissionValue("velocity.command.plugins") == Tristate.TRUE;
        }
    }

    private static class Info
    implements SubCommand {
        private static final TextColor VELOCITY_COLOR = TextColor.fromHexString("#09add3");
        private final ProxyServer server;

        private Info(ProxyServer server) {
            this.server = server;
        }

        @Override
        public void execute(CommandSource source, String @NonNull [] args) {
            if (args.length != 0) {
                source.sendMessage(Identity.nil(), (Component)Component.text("/velocity version", (TextColor)NamedTextColor.RED));
                return;
            }
            ProxyVersion version = this.server.getVersion();
            Object velocity = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().content(version.getName() + " ").decoration(TextDecoration.BOLD, true)).color(VELOCITY_COLOR)).append(Component.text(version.getVersion()).decoration(TextDecoration.BOLD, false))).build();
            TranslatableComponent copyright = Component.translatable("velocity.command.version-copyright", Component.text(version.getVendor()), Component.text(version.getName()));
            source.sendMessage(Identity.nil(), (Component)velocity);
            source.sendMessage(Identity.nil(), (Component)copyright);
            if (version.getName().equals("Velocity")) {
                TextComponent embellishment = (TextComponent)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)((TextComponent.Builder)((TextComponent.Builder)Component.text().content("velocitypowered.com").color(NamedTextColor.GREEN)).clickEvent(ClickEvent.openUrl("https://velocitypowered.com"))).build())).append((Component)Component.text(" - "))).append((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().content("GitHub").color(NamedTextColor.GREEN)).decoration(TextDecoration.UNDERLINED, true)).clickEvent(ClickEvent.openUrl("https://github.com/PaperMC/Velocity"))).build())).build();
                source.sendMessage(Identity.nil(), (Component)embellishment);
            }
        }

        @Override
        public boolean hasPermission(CommandSource source, String @NonNull [] args) {
            return source.getPermissionValue("velocity.command.info") != Tristate.FALSE;
        }
    }

    private static class Reload
    implements SubCommand {
        private static final Logger logger = LogManager.getLogger(Reload.class);
        private final VelocityServer server;

        private Reload(VelocityServer server) {
            this.server = server;
        }

        @Override
        public void execute(CommandSource source, String @NonNull [] args) {
            try {
                if (this.server.reloadConfiguration()) {
                    source.sendMessage(Component.translatable("velocity.command.reload-success", (TextColor)NamedTextColor.GREEN));
                } else {
                    source.sendMessage(Component.translatable("velocity.command.reload-failure", (TextColor)NamedTextColor.RED));
                }
            }
            catch (Exception e) {
                logger.error("Unable to reload configuration", (Throwable)e);
                source.sendMessage(Component.translatable("velocity.command.reload-failure", (TextColor)NamedTextColor.RED));
            }
        }

        @Override
        public boolean hasPermission(CommandSource source, String @NonNull [] args) {
            return source.getPermissionValue("velocity.command.reload") == Tristate.TRUE;
        }
    }

    private static interface SubCommand {
        public void execute(CommandSource var1, String @NonNull [] var2);

        default public List<String> suggest(CommandSource source, String @NonNull [] currentArgs) {
            return ImmutableList.of();
        }

        public boolean hasPermission(CommandSource var1, String @NonNull [] var2);
    }
}

