/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet.chat.keyed;

import com.velocitypowered.api.event.command.CommandExecuteEvent;
import com.velocitypowered.api.proxy.crypto.IdentifiedKey;
import com.velocitypowered.proxy.VelocityServer;
import com.velocitypowered.proxy.connection.client.ConnectedPlayer;
import com.velocitypowered.proxy.protocol.packet.chat.CommandHandler;
import com.velocitypowered.proxy.protocol.packet.chat.builder.ChatBuilderV2;
import com.velocitypowered.proxy.protocol.packet.chat.keyed.KeyedPlayerCommand;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;

public class KeyedCommandHandler
implements CommandHandler<KeyedPlayerCommand> {
    private final ConnectedPlayer player;
    private final VelocityServer server;

    public KeyedCommandHandler(ConnectedPlayer player, VelocityServer server) {
        this.player = player;
        this.server = server;
    }

    @Override
    public Class<KeyedPlayerCommand> packetClass() {
        return KeyedPlayerCommand.class;
    }

    @Override
    public void handlePlayerCommandInternal(KeyedPlayerCommand packet) {
        this.queueCommandResult(this.server, this.player, event -> {
            CommandExecuteEvent.CommandResult result = event.getResult();
            IdentifiedKey playerKey = this.player.getIdentifiedKey();
            if (result == CommandExecuteEvent.CommandResult.denied()) {
                if (playerKey != null && !packet.isUnsigned() && playerKey.getKeyRevision().compareTo(IdentifiedKey.Revision.LINKED_V2) >= 0) {
                    logger.fatal("A plugin tried to deny a command with signable component(s). This is not supported. Disconnecting player " + this.player.getUsername());
                    this.player.disconnect(Component.text("A proxy plugin caused an illegal protocol state. Contact your network administrator."));
                }
                return CompletableFuture.completedFuture(null);
            }
            String commandToRun = result.getCommand().orElse(packet.getCommand());
            if (result.isForwardToServer()) {
                ChatBuilderV2 write = this.player.getChatBuilderFactory().builder().setTimestamp(packet.getTimestamp()).asPlayer(this.player);
                if (!packet.isUnsigned() && commandToRun.equals(packet.getCommand())) {
                    return CompletableFuture.completedFuture(packet);
                }
                if (!packet.isUnsigned() && playerKey != null && playerKey.getKeyRevision().compareTo(IdentifiedKey.Revision.LINKED_V2) >= 0) {
                    logger.fatal("A plugin tried to change a command with signed component(s). This is not supported. Disconnecting player " + this.player.getUsername());
                    this.player.disconnect(Component.text("A proxy plugin caused an illegal protocol state. Contact your network administrator."));
                    return CompletableFuture.completedFuture(null);
                }
                write.message("/" + commandToRun);
                return CompletableFuture.completedFuture(write.toServer());
            }
            return this.runCommand(this.server, this.player, commandToRun, hasRun -> {
                if (!hasRun.booleanValue()) {
                    if (commandToRun.equals(packet.getCommand())) {
                        return packet;
                    }
                    if (!packet.isUnsigned() && playerKey != null && playerKey.getKeyRevision().compareTo(IdentifiedKey.Revision.LINKED_V2) >= 0) {
                        logger.fatal("A plugin tried to change a command with signed component(s). This is not supported. Disconnecting player " + this.player.getUsername());
                        this.player.disconnect(Component.text("A proxy plugin caused an illegal protocol state. Contact your network administrator."));
                        return null;
                    }
                    return this.player.getChatBuilderFactory().builder().setTimestamp(packet.getTimestamp()).asPlayer(this.player).message("/" + commandToRun).toServer();
                }
                return null;
            });
        }, packet.getCommand(), packet.getTimestamp());
    }
}

