/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet.chat.session;

import com.velocitypowered.api.event.command.CommandExecuteEvent;
import com.velocitypowered.proxy.VelocityServer;
import com.velocitypowered.proxy.connection.client.ConnectedPlayer;
import com.velocitypowered.proxy.protocol.packet.chat.CommandHandler;
import com.velocitypowered.proxy.protocol.packet.chat.session.SessionPlayerCommand;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;

public class SessionCommandHandler
implements CommandHandler<SessionPlayerCommand> {
    private final ConnectedPlayer player;
    private final VelocityServer server;

    public SessionCommandHandler(ConnectedPlayer player, VelocityServer server) {
        this.player = player;
        this.server = server;
    }

    @Override
    public Class<SessionPlayerCommand> packetClass() {
        return SessionPlayerCommand.class;
    }

    @Override
    public void handlePlayerCommandInternal(SessionPlayerCommand packet) {
        this.queueCommandResult(this.server, this.player, event -> {
            CommandExecuteEvent.CommandResult result = event.getResult();
            if (result == CommandExecuteEvent.CommandResult.denied()) {
                if (packet.isSigned()) {
                    logger.fatal("A plugin tried to deny a command with signable component(s). This is not supported. Disconnecting player " + this.player.getUsername());
                    this.player.disconnect(Component.text("A proxy plugin caused an illegal protocol state. Contact your network administrator."));
                }
                return CompletableFuture.completedFuture(null);
            }
            String commandToRun = result.getCommand().orElse(packet.command);
            if (result.isForwardToServer()) {
                if (packet.isSigned() && commandToRun.equals(packet.command)) {
                    return CompletableFuture.completedFuture(packet);
                }
                if (packet.isSigned()) {
                    logger.fatal("A plugin tried to change a command with signed component(s). This is not supported. Disconnecting player " + this.player.getUsername());
                    this.player.disconnect(Component.text("A proxy plugin caused an illegal protocol state. Contact your network administrator."));
                    return CompletableFuture.completedFuture(null);
                }
                return CompletableFuture.completedFuture(this.player.getChatBuilderFactory().builder().setTimestamp(packet.timeStamp).asPlayer(this.player).message("/" + commandToRun).toServer());
            }
            return this.runCommand(this.server, this.player, commandToRun, hasRun -> {
                if (!hasRun.booleanValue()) {
                    if (packet.isSigned() && commandToRun.equals(packet.command)) {
                        return packet;
                    }
                    if (packet.isSigned()) {
                        logger.fatal("A plugin tried to change a command with signed component(s). This is not supported. Disconnecting player " + this.player.getUsername());
                        this.player.disconnect(Component.text("A proxy plugin caused an illegal protocol state. Contact your network administrator."));
                        return null;
                    }
                    return this.player.getChatBuilderFactory().builder().setTimestamp(packet.timeStamp).asPlayer(this.player).message("/" + commandToRun).toServer();
                }
                return null;
            });
        }, packet.command, packet.timeStamp);
    }
}

