/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.scheduler;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.velocitypowered.api.plugin.PluginManager;
import com.velocitypowered.api.scheduler.ScheduledTask;
import com.velocitypowered.api.scheduler.Scheduler;
import com.velocitypowered.api.scheduler.TaskStatus;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class VelocityScheduler
implements Scheduler {
    private final PluginManager pluginManager;
    private final ExecutorService taskService;
    private final ScheduledExecutorService timerExecutionService;
    private final Multimap<Object, ScheduledTask> tasksByPlugin = Multimaps.synchronizedMultimap(Multimaps.newSetMultimap(new IdentityHashMap(), HashSet::new));

    public VelocityScheduler(PluginManager pluginManager) {
        this.pluginManager = pluginManager;
        this.taskService = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Velocity Task Scheduler - #%d").build());
        this.timerExecutionService = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Velocity Task Scheduler Timer").build());
    }

    @Override
    public Scheduler.TaskBuilder buildTask(Object plugin, Runnable runnable) {
        Preconditions.checkNotNull(plugin, "plugin");
        Preconditions.checkNotNull(runnable, "runnable");
        Preconditions.checkArgument(this.pluginManager.fromInstance(plugin).isPresent(), "plugin is not registered");
        return new TaskBuilderImpl(plugin, runnable, null);
    }

    @Override
    public Scheduler.TaskBuilder buildTask(Object plugin, Consumer<ScheduledTask> consumer) {
        Preconditions.checkNotNull(plugin, "plugin");
        Preconditions.checkNotNull(consumer, "consumer");
        Preconditions.checkArgument(this.pluginManager.fromInstance(plugin).isPresent(), "plugin is not registered");
        return new TaskBuilderImpl(plugin, null, consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @NonNull Collection<ScheduledTask> tasksByPlugin(@NonNull Object plugin) {
        Preconditions.checkNotNull(plugin, "plugin");
        Preconditions.checkArgument(this.pluginManager.fromInstance(plugin).isPresent(), "plugin is not registered");
        Collection<ScheduledTask> tasks = this.tasksByPlugin.get(plugin);
        Multimap<Object, ScheduledTask> multimap = this.tasksByPlugin;
        synchronized (multimap) {
            return Set.copyOf(tasks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shutdown() throws InterruptedException {
        ImmutableList<ScheduledTask> terminating;
        Multimap<Object, ScheduledTask> multimap = this.tasksByPlugin;
        synchronized (multimap) {
            terminating = ImmutableList.copyOf(this.tasksByPlugin.values());
        }
        for (ScheduledTask task : terminating) {
            task.cancel();
        }
        this.timerExecutionService.shutdown();
        this.taskService.shutdown();
        return this.taskService.awaitTermination(10L, TimeUnit.SECONDS);
    }

    private static class Log {
        private static final Logger logger = LogManager.getLogger(VelocityTask.class);

        private Log() {
        }
    }

    private class VelocityTask
    implements Runnable,
    ScheduledTask {
        private final Object plugin;
        private final Runnable runnable;
        private final Consumer<ScheduledTask> consumer;
        private final long delay;
        private final long repeat;
        private @Nullable ScheduledFuture<?> future;
        private volatile @Nullable Thread currentTaskThread;

        private VelocityTask(Object plugin, Runnable runnable, Consumer<ScheduledTask> consumer, long delay, long repeat) {
            this.plugin = plugin;
            this.runnable = runnable;
            this.consumer = consumer;
            this.delay = delay;
            this.repeat = repeat;
        }

        void schedule() {
            this.future = this.repeat == 0L ? VelocityScheduler.this.timerExecutionService.schedule(this, this.delay, TimeUnit.MILLISECONDS) : VelocityScheduler.this.timerExecutionService.scheduleAtFixedRate(this, this.delay, this.repeat, TimeUnit.MILLISECONDS);
        }

        @Override
        public Object plugin() {
            return this.plugin;
        }

        @Override
        public TaskStatus status() {
            if (this.future == null) {
                return TaskStatus.SCHEDULED;
            }
            if (this.future.isCancelled()) {
                return TaskStatus.CANCELLED;
            }
            if (this.future.isDone()) {
                return TaskStatus.FINISHED;
            }
            return TaskStatus.SCHEDULED;
        }

        @Override
        public void cancel() {
            if (this.future != null) {
                this.future.cancel(false);
                Thread cur = this.currentTaskThread;
                if (cur != null) {
                    cur.interrupt();
                }
                this.onFinish();
            }
        }

        @Override
        public void run() {
            VelocityScheduler.this.taskService.execute(() -> {
                this.currentTaskThread = Thread.currentThread();
                try {
                    if (this.runnable != null) {
                        this.runnable.run();
                    } else {
                        this.consumer.accept(this);
                    }
                }
                catch (Throwable e) {
                    if (e instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    } else {
                        String friendlyPluginName = VelocityScheduler.this.pluginManager.fromInstance(this.plugin).map(container -> container.getDescription().getName().orElse(container.getDescription().getId())).orElse("UNKNOWN");
                        Log.logger.error("Exception in task {} by plugin {}", (Object)this.runnable, (Object)friendlyPluginName, (Object)e);
                    }
                }
                finally {
                    if (this.repeat == 0L) {
                        this.onFinish();
                    }
                    this.currentTaskThread = null;
                }
            });
        }

        private void onFinish() {
            VelocityScheduler.this.tasksByPlugin.remove(this.plugin, this);
        }
    }

    private class TaskBuilderImpl
    implements Scheduler.TaskBuilder {
        private final Object plugin;
        private final Runnable runnable;
        private final Consumer<ScheduledTask> consumer;
        private long delay;
        private long repeat;

        private TaskBuilderImpl(Object plugin, Runnable runnable, Consumer<ScheduledTask> consumer) {
            this.plugin = plugin;
            this.runnable = runnable;
            this.consumer = consumer;
        }

        @Override
        public Scheduler.TaskBuilder delay(long time, TimeUnit unit) {
            this.delay = unit.toMillis(time);
            return this;
        }

        @Override
        public Scheduler.TaskBuilder repeat(long time, TimeUnit unit) {
            this.repeat = unit.toMillis(time);
            return this;
        }

        @Override
        public Scheduler.TaskBuilder clearDelay() {
            this.delay = 0L;
            return this;
        }

        @Override
        public Scheduler.TaskBuilder clearRepeat() {
            this.repeat = 0L;
            return this;
        }

        @Override
        public ScheduledTask schedule() {
            VelocityTask task = new VelocityTask(this.plugin, this.runnable, this.consumer, this.delay, this.repeat);
            VelocityScheduler.this.tasksByPlugin.put(this.plugin, task);
            task.schedule();
            return task;
        }
    }
}

