/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.command.builtin;

import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.velocitypowered.api.command.BrigadierCommand;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.permission.Tristate;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import com.velocitypowered.proxy.command.builtin.CommandMessages;
import java.util.Objects;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;

public class SendCommand {
    private final ProxyServer server;
    private static final String SERVER_ARG = "server";
    private static final String PLAYER_ARG = "player";

    public SendCommand(ProxyServer server) {
        this.server = server;
    }

    public void register() {
        CommandNode totalNode = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal("send").requires(source -> source.getPermissionValue("velocity.command.send") == Tristate.TRUE)).executes(this::usage)).build();
        CommandNode playerNode = ((RequiredArgumentBuilder)RequiredArgumentBuilder.argument(PLAYER_ARG, StringArgumentType.word()).suggests((context, builder) -> {
            String argument = context.getArguments().containsKey(PLAYER_ARG) ? context.getArgument(PLAYER_ARG, String.class) : "";
            for (Player player : this.server.getAllPlayers()) {
                String playerName = player.getUsername();
                if (!playerName.regionMatches(true, 0, argument, 0, argument.length())) continue;
                builder.suggest(playerName);
            }
            if ("all".regionMatches(true, 0, argument, 0, argument.length())) {
                builder.suggest("all");
            }
            if ("current".regionMatches(true, 0, argument, 0, argument.length()) && context.getSource() instanceof Player) {
                builder.suggest("current");
            }
            return builder.buildFuture();
        }).executes(this::usage)).build();
        CommandNode serverNode = ((RequiredArgumentBuilder)RequiredArgumentBuilder.argument(SERVER_ARG, StringArgumentType.word()).suggests((context, builder) -> {
            String argument = context.getArguments().containsKey(SERVER_ARG) ? context.getArgument(SERVER_ARG, String.class) : "";
            for (RegisteredServer server : this.server.getAllServers()) {
                String serverName = server.getServerInfo().getName();
                if (!serverName.regionMatches(true, 0, argument, 0, argument.length())) continue;
                builder.suggest(server.getServerInfo().getName());
            }
            return builder.buildFuture();
        }).executes(this::send)).build();
        totalNode.addChild(playerNode);
        playerNode.addChild(serverNode);
        this.server.getCommandManager().register(new BrigadierCommand((LiteralCommandNode<CommandSource>)totalNode));
    }

    private int usage(CommandContext<CommandSource> context) {
        context.getSource().sendMessage(Component.translatable("velocity.command.send-usage", (TextColor)NamedTextColor.YELLOW));
        return 1;
    }

    private int send(CommandContext<CommandSource> context) {
        String serverName = context.getArgument(SERVER_ARG, String.class);
        String player = context.getArgument(PLAYER_ARG, String.class);
        Optional<RegisteredServer> maybeServer = this.server.getServer(serverName);
        if (maybeServer.isEmpty()) {
            context.getSource().sendMessage(CommandMessages.SERVER_DOES_NOT_EXIST.args(Component.text(serverName)));
            return 0;
        }
        if (this.server.getPlayer(player).isEmpty() && !Objects.equals(player, "all") && !Objects.equals(player, "current")) {
            context.getSource().sendMessage(CommandMessages.PLAYER_NOT_FOUND.args(Component.text(player)));
            return 0;
        }
        if (Objects.equals(player, "all")) {
            for (Player p : this.server.getAllPlayers()) {
                p.createConnectionRequest(this.server.getServer(serverName).get()).fireAndForget();
            }
            return 1;
        }
        if (Objects.equals(player, "current")) {
            if (!(context.getSource() instanceof Player)) {
                context.getSource().sendMessage(CommandMessages.PLAYERS_ONLY);
                return 0;
            }
            Player source = (Player)context.getSource();
            Optional<ServerConnection> connectedServer = source.getCurrentServer();
            if (connectedServer.isPresent()) {
                for (Player p : connectedServer.get().getServer().getPlayersConnected()) {
                    p.createConnectionRequest(maybeServer.get()).fireAndForget();
                }
                return 1;
            }
            return 0;
        }
        this.server.getPlayer(player).get().createConnectionRequest(maybeServer.get()).fireAndForget();
        return 1;
    }
}

