/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.connection.backend;

import com.velocitypowered.api.event.player.PlayerResourcePackStatusEvent;
import com.velocitypowered.api.event.player.ServerResourcePackSendEvent;
import com.velocitypowered.api.proxy.player.ResourcePackInfo;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import com.velocitypowered.proxy.VelocityServer;
import com.velocitypowered.proxy.connection.MinecraftConnection;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.connection.backend.TransitionSessionHandler;
import com.velocitypowered.proxy.connection.backend.VelocityServerConnection;
import com.velocitypowered.proxy.connection.client.ClientConfigSessionHandler;
import com.velocitypowered.proxy.connection.client.ConnectedPlayer;
import com.velocitypowered.proxy.connection.player.VelocityResourcePackInfo;
import com.velocitypowered.proxy.connection.util.ConnectionMessages;
import com.velocitypowered.proxy.connection.util.ConnectionRequestResults;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.StateRegistry;
import com.velocitypowered.proxy.protocol.netty.MinecraftDecoder;
import com.velocitypowered.proxy.protocol.packet.Disconnect;
import com.velocitypowered.proxy.protocol.packet.KeepAlive;
import com.velocitypowered.proxy.protocol.packet.PluginMessage;
import com.velocitypowered.proxy.protocol.packet.ResourcePackRequest;
import com.velocitypowered.proxy.protocol.packet.ResourcePackResponse;
import com.velocitypowered.proxy.protocol.packet.config.FinishedUpdate;
import com.velocitypowered.proxy.protocol.packet.config.RegistrySync;
import com.velocitypowered.proxy.protocol.packet.config.StartUpdate;
import com.velocitypowered.proxy.protocol.packet.config.TagsUpdate;
import com.velocitypowered.proxy.protocol.util.PluginMessageUtil;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigSessionHandler
implements MinecraftSessionHandler {
    private static final Pattern PLAUSIBLE_SHA1_HASH = Pattern.compile("^[a-z0-9]{40}$");
    private static final Logger logger = LogManager.getLogger(ConfigSessionHandler.class);
    private final VelocityServer server;
    private final VelocityServerConnection serverConn;
    private final CompletableFuture<ConnectionRequestResults.Impl> resultFuture;
    private ResourcePackInfo resourcePackToApply;
    private State state;

    ConfigSessionHandler(VelocityServer server, VelocityServerConnection serverConn, CompletableFuture<ConnectionRequestResults.Impl> resultFuture) {
        this.server = server;
        this.serverConn = serverConn;
        this.resultFuture = resultFuture;
        this.state = State.START;
    }

    @Override
    public void activated() {
        this.resourcePackToApply = this.serverConn.getPlayer().getAppliedResourcePack();
        this.serverConn.getPlayer().clearAppliedResourcePack();
    }

    @Override
    public boolean beforeHandle() {
        if (!this.serverConn.isActive()) {
            this.serverConn.disconnect();
            return true;
        }
        return false;
    }

    @Override
    public boolean handle(StartUpdate packet) {
        this.serverConn.ensureConnected().write(packet);
        return true;
    }

    @Override
    public boolean handle(TagsUpdate packet) {
        this.serverConn.getPlayer().getConnection().write(packet);
        return true;
    }

    @Override
    public boolean handle(KeepAlive packet) {
        this.serverConn.ensureConnected().write(packet);
        return true;
    }

    @Override
    public boolean handle(ResourcePackRequest packet) {
        MinecraftConnection playerConnection = this.serverConn.getPlayer().getConnection();
        ServerResourcePackSendEvent event = new ServerResourcePackSendEvent(packet.toServerPromptedPack(), this.serverConn);
        ((CompletableFuture)this.server.getEventManager().fire(event).thenAcceptAsync(serverResourcePackSendEvent -> {
            if (playerConnection.isClosed()) {
                return;
            }
            if (serverResourcePackSendEvent.getResult().isAllowed()) {
                ResourcePackInfo toSend = serverResourcePackSendEvent.getProvidedResourcePack();
                if (toSend != serverResourcePackSendEvent.getReceivedResourcePack()) {
                    ((VelocityResourcePackInfo)toSend).setOriginalOrigin(ResourcePackInfo.Origin.DOWNSTREAM_SERVER);
                }
                this.resourcePackToApply = null;
                this.serverConn.getPlayer().queueResourcePack(toSend);
            } else if (this.serverConn.getConnection() != null) {
                this.serverConn.getConnection().write(new ResourcePackResponse(packet.getHash(), PlayerResourcePackStatusEvent.Status.DECLINED));
            }
        }, (Executor)playerConnection.eventLoop())).exceptionally(ex -> {
            if (this.serverConn.getConnection() != null) {
                this.serverConn.getConnection().write(new ResourcePackResponse(packet.getHash(), PlayerResourcePackStatusEvent.Status.DECLINED));
            }
            logger.error("Exception while handling resource pack send for {}", (Object)playerConnection, ex);
            return null;
        });
        return true;
    }

    @Override
    public boolean handle(FinishedUpdate packet) {
        MinecraftConnection smc = this.serverConn.ensureConnected();
        ConnectedPlayer player = this.serverConn.getPlayer();
        ClientConfigSessionHandler configHandler = (ClientConfigSessionHandler)player.getConnection().getActiveSessionHandler();
        smc.setAutoReading(false);
        smc.getChannel().pipeline().get(MinecraftDecoder.class).setState(StateRegistry.PLAY);
        configHandler.handleBackendFinishUpdate(this.serverConn).thenAcceptAsync(unused -> {
            if (this.serverConn == player.getConnectedServer()) {
                smc.setActiveSessionHandler(StateRegistry.PLAY);
                player.sendPlayerListHeaderAndFooter(player.getPlayerListHeader(), player.getPlayerListFooter());
                player.getTabList().clearAllSilent();
            } else {
                smc.setActiveSessionHandler(StateRegistry.PLAY, new TransitionSessionHandler(this.server, this.serverConn, this.resultFuture));
            }
            if (player.getAppliedResourcePack() == null && this.resourcePackToApply != null) {
                player.queueResourcePack(this.resourcePackToApply);
            }
            smc.setAutoReading(true);
        }, (Executor)smc.eventLoop());
        return true;
    }

    @Override
    public boolean handle(Disconnect packet) {
        this.serverConn.disconnect();
        this.resultFuture.complete(ConnectionRequestResults.forDisconnect(packet, (RegisteredServer)this.serverConn.getServer()));
        return true;
    }

    @Override
    public boolean handle(PluginMessage packet) {
        if (PluginMessageUtil.isMcBrand(packet)) {
            this.serverConn.getPlayer().getConnection().write(PluginMessageUtil.rewriteMinecraftBrand(packet, this.server.getVersion(), this.serverConn.getPlayer().getProtocolVersion()));
        } else {
            this.serverConn.getPlayer().getConnection().write(packet.retain());
        }
        return true;
    }

    @Override
    public boolean handle(RegistrySync packet) {
        this.serverConn.getPlayer().getConnection().write(packet.retain());
        return true;
    }

    @Override
    public void disconnected() {
        this.resultFuture.completeExceptionally(new IOException("Unexpectedly disconnected from remote server"));
    }

    @Override
    public void handleGeneric(MinecraftPacket packet) {
        this.serverConn.getPlayer().getConnection().write(packet);
    }

    private void switchFailure(Throwable cause) {
        logger.error("Unable to switch to new server {} for {}", (Object)this.serverConn.getServerInfo().getName(), (Object)this.serverConn.getPlayer().getUsername(), (Object)cause);
        this.serverConn.getPlayer().disconnect(ConnectionMessages.INTERNAL_SERVER_CONNECTION_ERROR);
        this.resultFuture.completeExceptionally(cause);
    }

    public static enum State {
        START,
        NEGOTIATING,
        PLUGIN_MESSAGE_INTERRUPT,
        RESOURCE_PACK_INTERRUPT,
        COMPLETE;

    }
}

