/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.connection.client;

import com.velocitypowered.api.event.player.PlayerClientBrandEvent;
import com.velocitypowered.proxy.VelocityServer;
import com.velocitypowered.proxy.connection.MinecraftConnection;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.connection.backend.VelocityServerConnection;
import com.velocitypowered.proxy.connection.client.ClientPlaySessionHandler;
import com.velocitypowered.proxy.connection.client.ConnectedPlayer;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import com.velocitypowered.proxy.protocol.StateRegistry;
import com.velocitypowered.proxy.protocol.packet.ClientSettings;
import com.velocitypowered.proxy.protocol.packet.KeepAlive;
import com.velocitypowered.proxy.protocol.packet.PingIdentify;
import com.velocitypowered.proxy.protocol.packet.PluginMessage;
import com.velocitypowered.proxy.protocol.packet.ResourcePackResponse;
import com.velocitypowered.proxy.protocol.packet.config.FinishedUpdate;
import com.velocitypowered.proxy.protocol.util.PluginMessageUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientConfigSessionHandler
implements MinecraftSessionHandler {
    private static final Logger logger = LogManager.getLogger(ClientConfigSessionHandler.class);
    private final VelocityServer server;
    private final ConnectedPlayer player;
    private String brandChannel = null;
    private CompletableFuture<Void> configSwitchFuture;

    public ClientConfigSessionHandler(VelocityServer server, ConnectedPlayer player) {
        this.server = server;
        this.player = player;
    }

    @Override
    public void activated() {
        this.configSwitchFuture = new CompletableFuture();
    }

    @Override
    public void deactivated() {
    }

    @Override
    public boolean handle(KeepAlive packet) {
        MinecraftConnection smc;
        Long sentTime;
        VelocityServerConnection serverConnection = this.player.getConnectedServer();
        if (serverConnection != null && (sentTime = serverConnection.getPendingPings().remove(packet.getRandomId())) != null && (smc = serverConnection.getConnection()) != null) {
            this.player.setPing(System.currentTimeMillis() - sentTime);
            smc.write(packet);
        }
        return true;
    }

    @Override
    public boolean handle(ClientSettings packet) {
        this.player.setClientSettings(packet);
        return true;
    }

    @Override
    public boolean handle(ResourcePackResponse packet) {
        if (this.player.getConnectionInFlight() != null) {
            this.player.getConnectionInFlight().ensureConnected().write(packet);
        }
        return this.player.onResourcePackResponse(packet.getStatus());
    }

    @Override
    public boolean handle(FinishedUpdate packet) {
        this.player.getConnection().setActiveSessionHandler(StateRegistry.PLAY, new ClientPlaySessionHandler(this.server, this.player));
        this.configSwitchFuture.complete(null);
        return true;
    }

    @Override
    public boolean handle(PluginMessage packet) {
        VelocityServerConnection serverConn = this.player.getConnectionInFlight();
        if (serverConn != null) {
            if (PluginMessageUtil.isMcBrand(packet)) {
                String brand = PluginMessageUtil.readBrandMessage(packet.content());
                this.server.getEventManager().fireAndForget(new PlayerClientBrandEvent(this.player, brand));
                this.player.setClientBrand(brand);
                this.brandChannel = packet.getChannel();
            } else {
                serverConn.ensureConnected().write(packet.retain());
            }
        }
        return true;
    }

    @Override
    public boolean handle(PingIdentify packet) {
        if (this.player.getConnectionInFlight() != null) {
            this.player.getConnectionInFlight().ensureConnected().write(packet);
        }
        return true;
    }

    @Override
    public void handleGeneric(MinecraftPacket packet) {
        VelocityServerConnection serverConnection = this.player.getConnectedServer();
        if (serverConnection == null) {
            return;
        }
        MinecraftConnection smc = serverConnection.getConnection();
        if (smc != null && serverConnection.getPhase().consideredComplete()) {
            if (packet instanceof PluginMessage) {
                ((PluginMessage)packet).retain();
            }
            smc.write(packet);
        }
    }

    @Override
    public void handleUnknown(ByteBuf buf) {
        VelocityServerConnection serverConnection = this.player.getConnectedServer();
        if (serverConnection == null) {
            return;
        }
        MinecraftConnection smc = serverConnection.getConnection();
        if (smc != null && !smc.isClosed() && serverConnection.getPhase().consideredComplete()) {
            smc.write(buf.retain());
        }
    }

    @Override
    public void disconnected() {
        this.player.teardown();
    }

    @Override
    public void exception(Throwable throwable) {
        this.player.disconnect(Component.translatable("velocity.error.player-connection-error", (TextColor)NamedTextColor.RED));
    }

    public CompletableFuture<Void> handleBackendFinishUpdate(VelocityServerConnection serverConn) {
        String brand = serverConn.getPlayer().getClientBrand();
        if (brand != null && this.brandChannel != null) {
            ByteBuf buf = Unpooled.buffer();
            ProtocolUtils.writeString(buf, brand);
            PluginMessage brandPacket = new PluginMessage(this.brandChannel, buf);
            serverConn.ensureConnected().write(brandPacket);
        }
        this.player.getConnection().write(new FinishedUpdate());
        serverConn.ensureConnected().write(new FinishedUpdate());
        return this.configSwitchFuture;
    }
}

