/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet;

import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import com.velocitypowered.proxy.protocol.util.DeferredByteBufHolder;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.checkerframework.checker.nullness.qual.Nullable;

public class LoginPluginMessage
extends DeferredByteBufHolder
implements MinecraftPacket {
    private int id;
    private @Nullable String channel;

    public LoginPluginMessage() {
        super(null);
    }

    public LoginPluginMessage(int id, @Nullable String channel, ByteBuf data) {
        super(data);
        this.id = id;
        this.channel = channel;
    }

    public int getId() {
        return this.id;
    }

    public String getChannel() {
        if (this.channel == null) {
            throw new IllegalStateException("Channel is not specified!");
        }
        return this.channel;
    }

    @Override
    public String toString() {
        return "LoginPluginMessage{id=" + this.id + ", channel='" + this.channel + "', data=" + super.toString() + "}";
    }

    @Override
    public void decode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion version) {
        this.id = ProtocolUtils.readVarInt(buf);
        this.channel = ProtocolUtils.readString(buf);
        if (buf.isReadable()) {
            this.replace(buf.readRetainedSlice(buf.readableBytes()));
        } else {
            this.replace(Unpooled.EMPTY_BUFFER);
        }
    }

    @Override
    public void encode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion version) {
        ProtocolUtils.writeVarInt(buf, this.id);
        if (this.channel == null) {
            throw new IllegalStateException("Channel is not specified!");
        }
        ProtocolUtils.writeString(buf, this.channel);
        buf.writeBytes(this.content());
    }

    @Override
    public boolean handle(MinecraftSessionHandler handler) {
        return handler.handle(this);
    }
}

