/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet;

import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.connection.registry.DimensionInfo;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import com.velocitypowered.proxy.protocol.packet.JoinGame;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.Pair;
import net.kyori.adventure.nbt.BinaryTagIO;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Respawn
implements MinecraftPacket {
    private int dimension;
    private long partialHashedSeed;
    private short difficulty;
    private short gamemode;
    private String levelType = "";
    private byte dataToKeep;
    private DimensionInfo dimensionInfo;
    private short previousGamemode;
    private CompoundBinaryTag currentDimensionData;
    private @Nullable Pair<String, Long> lastDeathPosition;
    private int portalCooldown;

    public Respawn() {
    }

    public Respawn(int dimension, long partialHashedSeed, short difficulty, short gamemode, String levelType, byte dataToKeep, DimensionInfo dimensionInfo, short previousGamemode, CompoundBinaryTag currentDimensionData, @Nullable Pair<String, Long> lastDeathPosition, int portalCooldown) {
        this.dimension = dimension;
        this.partialHashedSeed = partialHashedSeed;
        this.difficulty = difficulty;
        this.gamemode = gamemode;
        this.levelType = levelType;
        this.dataToKeep = dataToKeep;
        this.dimensionInfo = dimensionInfo;
        this.previousGamemode = previousGamemode;
        this.currentDimensionData = currentDimensionData;
        this.lastDeathPosition = lastDeathPosition;
        this.portalCooldown = portalCooldown;
    }

    public static Respawn fromJoinGame(JoinGame joinGame) {
        return new Respawn(joinGame.getDimension(), joinGame.getPartialHashedSeed(), joinGame.getDifficulty(), joinGame.getGamemode(), joinGame.getLevelType(), 0, joinGame.getDimensionInfo(), joinGame.getPreviousGamemode(), joinGame.getCurrentDimensionData(), joinGame.getLastDeathPosition(), joinGame.getPortalCooldown());
    }

    public int getDimension() {
        return this.dimension;
    }

    public void setDimension(int dimension) {
        this.dimension = dimension;
    }

    public long getPartialHashedSeed() {
        return this.partialHashedSeed;
    }

    public void setPartialHashedSeed(long partialHashedSeed) {
        this.partialHashedSeed = partialHashedSeed;
    }

    public short getDifficulty() {
        return this.difficulty;
    }

    public void setDifficulty(short difficulty) {
        this.difficulty = difficulty;
    }

    public short getGamemode() {
        return this.gamemode;
    }

    public void setGamemode(short gamemode) {
        this.gamemode = gamemode;
    }

    public String getLevelType() {
        return this.levelType;
    }

    public void setLevelType(String levelType) {
        this.levelType = levelType;
    }

    public byte getDataToKeep() {
        return this.dataToKeep;
    }

    public void setDataToKeep(byte dataToKeep) {
        this.dataToKeep = dataToKeep;
    }

    public short getPreviousGamemode() {
        return this.previousGamemode;
    }

    public void setPreviousGamemode(short previousGamemode) {
        this.previousGamemode = previousGamemode;
    }

    public Pair<String, Long> getLastDeathPosition() {
        return this.lastDeathPosition;
    }

    public void setLastDeathPosition(Pair<String, Long> lastDeathPosition) {
        this.lastDeathPosition = lastDeathPosition;
    }

    public int getPortalCooldown() {
        return this.portalCooldown;
    }

    public void setPortalCooldown(int portalCooldown) {
        this.portalCooldown = portalCooldown;
    }

    public String toString() {
        return "Respawn{dimension=" + this.dimension + ", partialHashedSeed=" + this.partialHashedSeed + ", difficulty=" + this.difficulty + ", gamemode=" + this.gamemode + ", levelType='" + this.levelType + "', dataToKeep=" + this.dataToKeep + ", dimensionRegistryName='" + this.dimensionInfo.toString() + "', dimensionInfo=" + this.dimensionInfo + ", previousGamemode=" + this.previousGamemode + ", dimensionData=" + this.currentDimensionData + ", portalCooldown=" + this.portalCooldown + "}";
    }

    @Override
    public void decode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion version) {
        String dimensionIdentifier = null;
        String levelName = null;
        if (version.compareTo(ProtocolVersion.MINECRAFT_1_16) >= 0) {
            if (version.compareTo(ProtocolVersion.MINECRAFT_1_16_2) >= 0 && version.compareTo(ProtocolVersion.MINECRAFT_1_19) < 0) {
                this.currentDimensionData = ProtocolUtils.readCompoundTag(buf, BinaryTagIO.reader());
                dimensionIdentifier = ProtocolUtils.readString(buf);
            } else {
                dimensionIdentifier = ProtocolUtils.readString(buf);
                levelName = ProtocolUtils.readString(buf);
            }
        } else {
            this.dimension = buf.readInt();
        }
        if (version.compareTo(ProtocolVersion.MINECRAFT_1_13_2) <= 0) {
            this.difficulty = buf.readUnsignedByte();
        }
        if (version.compareTo(ProtocolVersion.MINECRAFT_1_15) >= 0) {
            this.partialHashedSeed = buf.readLong();
        }
        this.gamemode = buf.readByte();
        if (version.compareTo(ProtocolVersion.MINECRAFT_1_16) >= 0) {
            this.previousGamemode = buf.readByte();
            boolean isDebug = buf.readBoolean();
            boolean isFlat = buf.readBoolean();
            this.dimensionInfo = new DimensionInfo(dimensionIdentifier, levelName, isFlat, isDebug);
            this.dataToKeep = version.compareTo(ProtocolVersion.MINECRAFT_1_19_3) >= 0 ? buf.readByte() : (buf.readBoolean() ? (byte)1 : 0);
        } else {
            this.levelType = ProtocolUtils.readString(buf, 16);
        }
        if (version.compareTo(ProtocolVersion.MINECRAFT_1_19) >= 0 && buf.readBoolean()) {
            this.lastDeathPosition = Pair.of(ProtocolUtils.readString(buf), buf.readLong());
        }
        if (version.compareTo(ProtocolVersion.MINECRAFT_1_20) >= 0) {
            this.portalCooldown = ProtocolUtils.readVarInt(buf);
        }
    }

    @Override
    public void encode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion version) {
        if (version.compareTo(ProtocolVersion.MINECRAFT_1_16) >= 0) {
            if (version.compareTo(ProtocolVersion.MINECRAFT_1_16_2) >= 0 && version.compareTo(ProtocolVersion.MINECRAFT_1_19) < 0) {
                ProtocolUtils.writeCompoundTag(buf, this.currentDimensionData);
                ProtocolUtils.writeString(buf, this.dimensionInfo.getRegistryIdentifier());
            } else {
                ProtocolUtils.writeString(buf, this.dimensionInfo.getRegistryIdentifier());
                ProtocolUtils.writeString(buf, this.dimensionInfo.getLevelName());
            }
        } else {
            buf.writeInt(this.dimension);
        }
        if (version.compareTo(ProtocolVersion.MINECRAFT_1_13_2) <= 0) {
            buf.writeByte(this.difficulty);
        }
        if (version.compareTo(ProtocolVersion.MINECRAFT_1_15) >= 0) {
            buf.writeLong(this.partialHashedSeed);
        }
        buf.writeByte(this.gamemode);
        if (version.compareTo(ProtocolVersion.MINECRAFT_1_16) >= 0) {
            buf.writeByte(this.previousGamemode);
            buf.writeBoolean(this.dimensionInfo.isDebugType());
            buf.writeBoolean(this.dimensionInfo.isFlat());
            if (version.compareTo(ProtocolVersion.MINECRAFT_1_19_3) >= 0) {
                buf.writeByte(this.dataToKeep);
            } else {
                buf.writeBoolean(this.dataToKeep != 0);
            }
        } else {
            ProtocolUtils.writeString(buf, this.levelType);
        }
        if (version.compareTo(ProtocolVersion.MINECRAFT_1_19) >= 0) {
            if (this.lastDeathPosition != null) {
                buf.writeBoolean(true);
                ProtocolUtils.writeString(buf, this.lastDeathPosition.key());
                buf.writeLong(this.lastDeathPosition.value());
            } else {
                buf.writeBoolean(false);
            }
        }
        if (version.compareTo(ProtocolVersion.MINECRAFT_1_20) >= 0) {
            ProtocolUtils.writeVarInt(buf, this.portalCooldown);
        }
    }

    @Override
    public boolean handle(MinecraftSessionHandler handler) {
        return handler.handle(this);
    }
}

