/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet.brigadier;

import com.google.common.base.Preconditions;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import com.velocitypowered.proxy.protocol.packet.brigadier.ArgumentIdentifier;
import com.velocitypowered.proxy.protocol.packet.brigadier.ArgumentPropertySerializer;
import com.velocitypowered.proxy.protocol.packet.brigadier.ByteArgumentPropertySerializer;
import com.velocitypowered.proxy.protocol.packet.brigadier.DoubleArgumentPropertySerializer;
import com.velocitypowered.proxy.protocol.packet.brigadier.EmptyArgumentPropertySerializer;
import com.velocitypowered.proxy.protocol.packet.brigadier.FloatArgumentPropertySerializer;
import com.velocitypowered.proxy.protocol.packet.brigadier.IntegerArgumentPropertySerializer;
import com.velocitypowered.proxy.protocol.packet.brigadier.LongArgumentPropertySerializer;
import com.velocitypowered.proxy.protocol.packet.brigadier.ModArgumentProperty;
import com.velocitypowered.proxy.protocol.packet.brigadier.ModArgumentPropertySerializer;
import com.velocitypowered.proxy.protocol.packet.brigadier.PassthroughProperty;
import com.velocitypowered.proxy.protocol.packet.brigadier.RegistryKeyArgument;
import com.velocitypowered.proxy.protocol.packet.brigadier.RegistryKeyArgumentList;
import com.velocitypowered.proxy.protocol.packet.brigadier.RegistryKeyArgumentSerializer;
import com.velocitypowered.proxy.protocol.packet.brigadier.StringArgumentPropertySerializer;
import com.velocitypowered.proxy.protocol.packet.brigadier.TimeArgumentSerializer;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;

public class ArgumentPropertyRegistry {
    private static final Map<ArgumentIdentifier, ArgumentPropertySerializer<?>> byIdentifier = new HashMap();
    private static final Map<Class<? extends ArgumentType>, ArgumentPropertySerializer<?>> byClass = new HashMap();
    private static final Map<Class<? extends ArgumentType>, ArgumentIdentifier> classToId = new HashMap<Class<? extends ArgumentType>, ArgumentIdentifier>();

    private ArgumentPropertyRegistry() {
        throw new AssertionError();
    }

    private static <T extends ArgumentType<?>> void register(ArgumentIdentifier identifier, Class<T> klazz, ArgumentPropertySerializer<T> serializer) {
        byIdentifier.put(identifier, serializer);
        byClass.put(klazz, serializer);
        classToId.put(klazz, identifier);
    }

    private static <T> void empty(ArgumentIdentifier identifier) {
        ArgumentPropertyRegistry.empty(identifier, EmptyArgumentPropertySerializer.EMPTY);
    }

    private static <T> void empty(ArgumentIdentifier identifier, ArgumentPropertySerializer<T> serializer) {
        byIdentifier.put(identifier, serializer);
    }

    public static ArgumentType<?> deserialize(ByteBuf buf, ProtocolVersion protocolVersion) {
        ArgumentIdentifier identifier = ArgumentPropertyRegistry.readIdentifier(buf, protocolVersion);
        ArgumentPropertySerializer<?> serializer = byIdentifier.get(identifier);
        if (serializer == null) {
            throw new IllegalArgumentException("Argument type identifier " + identifier + " unknown.");
        }
        Object result = serializer.deserialize(buf, protocolVersion);
        if (result instanceof ArgumentType) {
            return (ArgumentType)result;
        }
        return new PassthroughProperty(identifier, serializer, result);
    }

    public static void serialize(ByteBuf buf, ArgumentType<?> type, ProtocolVersion protocolVersion) {
        if (type instanceof PassthroughProperty) {
            PassthroughProperty property = (PassthroughProperty)type;
            ArgumentPropertyRegistry.writeIdentifier(buf, property.getIdentifier(), protocolVersion);
            if (property.getResult() != null) {
                property.getSerializer().serialize(property.getResult(), buf, protocolVersion);
            }
        } else if (type instanceof ModArgumentProperty) {
            ModArgumentProperty property = (ModArgumentProperty)type;
            ArgumentPropertyRegistry.writeIdentifier(buf, property.getIdentifier(), protocolVersion);
            buf.writeBytes(property.getData());
        } else {
            ArgumentPropertySerializer<?> serializer = byClass.get(type.getClass());
            ArgumentIdentifier id = classToId.get(type.getClass());
            if (serializer == null || id == null) {
                throw new IllegalArgumentException("Don't know how to serialize " + type.getClass().getName());
            }
            ArgumentPropertyRegistry.writeIdentifier(buf, id, protocolVersion);
            serializer.serialize(type, buf, protocolVersion);
        }
    }

    public static void writeIdentifier(ByteBuf buf, ArgumentIdentifier identifier, ProtocolVersion protocolVersion) {
        if (protocolVersion.compareTo(ProtocolVersion.MINECRAFT_1_19) >= 0) {
            Integer id = identifier.getIdByProtocolVersion(protocolVersion);
            Preconditions.checkNotNull(id, "Don't know how to serialize type " + identifier);
            ProtocolUtils.writeVarInt(buf, id);
        } else {
            ProtocolUtils.writeString(buf, identifier.getIdentifier());
        }
    }

    public static ArgumentIdentifier readIdentifier(ByteBuf buf, ProtocolVersion protocolVersion) {
        if (protocolVersion.compareTo(ProtocolVersion.MINECRAFT_1_19) >= 0) {
            int id = ProtocolUtils.readVarInt(buf);
            for (ArgumentIdentifier i : byIdentifier.keySet()) {
                Integer v = i.getIdByProtocolVersion(protocolVersion);
                if (v == null || v != id) continue;
                return i;
            }
        } else {
            String identifier = ProtocolUtils.readString(buf);
            for (ArgumentIdentifier i : byIdentifier.keySet()) {
                if (!i.getIdentifier().equals(identifier)) continue;
                return i;
            }
        }
        return null;
    }

    static {
        ArgumentPropertyRegistry.register(ArgumentIdentifier.id("brigadier:bool", ArgumentIdentifier.mapSet(ProtocolVersion.MINECRAFT_1_19, 0)), BoolArgumentType.class, new ArgumentPropertySerializer<BoolArgumentType>(){

            @Override
            public BoolArgumentType deserialize(ByteBuf buf, ProtocolVersion protocolVersion) {
                return BoolArgumentType.bool();
            }

            @Override
            public void serialize(BoolArgumentType object, ByteBuf buf, ProtocolVersion protocolVersion) {
            }
        });
        ArgumentPropertyRegistry.register(ArgumentIdentifier.id("brigadier:float", ArgumentIdentifier.mapSet(ProtocolVersion.MINECRAFT_1_19, 1)), FloatArgumentType.class, FloatArgumentPropertySerializer.FLOAT);
        ArgumentPropertyRegistry.register(ArgumentIdentifier.id("brigadier:double", ArgumentIdentifier.mapSet(ProtocolVersion.MINECRAFT_1_19, 2)), DoubleArgumentType.class, DoubleArgumentPropertySerializer.DOUBLE);
        ArgumentPropertyRegistry.register(ArgumentIdentifier.id("brigadier:integer", ArgumentIdentifier.mapSet(ProtocolVersion.MINECRAFT_1_19, 3)), IntegerArgumentType.class, IntegerArgumentPropertySerializer.INTEGER);
        ArgumentPropertyRegistry.register(ArgumentIdentifier.id("brigadier:long", ArgumentIdentifier.mapSet(ProtocolVersion.MINECRAFT_1_19, 4)), LongArgumentType.class, LongArgumentPropertySerializer.LONG);
        ArgumentPropertyRegistry.register(ArgumentIdentifier.id("brigadier:string", ArgumentIdentifier.mapSet(ProtocolVersion.MINECRAFT_1_19, 5)), StringArgumentType.class, StringArgumentPropertySerializer.STRING);
        ArgumentPropertyRegistry.empty(ArgumentIdentifier.id("minecraft:entity", ArgumentIdentifier.mapSet(ProtocolVersion.MINECRAFT_1_19, 6)), ByteArgumentPropertySerializer.BYTE);
        ArgumentPropertyRegistry.empty(ArgumentIdentifier.id("minecraft:game_profile", ArgumentIdentifier.mapSet(ProtocolVersion.MINECRAFT_1_19, 7)));
        ArgumentPropertyRegistry.empty(ArgumentIdentifier.id("minecraft:block_pos", ArgumentIdentifier.mapSet(ProtocolVersion.MINECRAFT_1_19, 8)));
        ArgumentPropertyRegistry.empty(ArgumentIdentifier.id("minecraft:column_pos", ArgumentIdentifier.mapSet(ProtocolVersion.MINECRAFT_1_19, 9)));
        ArgumentPropertyRegistry.empty(ArgumentIdentifier.id("minecraft:vec3", ArgumentIdentifier.mapSet(ProtocolVersion.MINECRAFT_1_19, 10)));
        ArgumentPropertyRegistry.empty(ArgumentIdentifier.id("minecraft:vec2", ArgumentIdentifier.mapSet(ProtocolVersion.MINECRAFT_1_19, 11)));
        ArgumentPropertyRegistry.empty(ArgumentIdentifier.id("minecraft:block_state", ArgumentIdentifier.mapSet(ProtocolVersion.MINECRAFT_1_19, 12)));
        ArgumentPropertyRegistry.empty(ArgumentIdentifier.id("minecraft:block_predicate", ArgumentIdentifier.mapSet(ProtocolVersion.MINECRAFT_1_19, 13)));
        ArgumentPropertyRegistry.empty(ArgumentIdentifier.id("minecraft:item_stack", ArgumentIdentifier.mapSet(ProtocolVersion.MINECRAFT_1_19, 14)));
        ArgumentPropertyRegistry.empty(ArgumentIdentifier.id("minecraft:item_predicate", ArgumentIdentifier.mapSet(ProtocolVersion.MINECRAFT_1_19, 15)));
        ArgumentPropertyRegistry.empty(ArgumentIdentifier.id("minecraft:color", ArgumentIdentifier.mapSet(ProtocolVersion.MINECRAFT_1_19, 16)));
        ArgumentPropertyRegistry.empty(ArgumentIdentifier.id("minecraft:component", ArgumentIdentifier.mapSet(ProtocolVersion.MINECRAFT_1_19, 17)));
        ArgumentPropertyRegistry.empty(ArgumentIdentifier.id("minecraft:message", ArgumentIdentifier.mapSet(ProtocolVersion.MINECRAFT_1_19, 18)));
        ArgumentPropertyRegistry.empty(ArgumentIdentifier.id("minecraft:nbt_compound_tag", ArgumentIdentifier.mapSet(ProtocolVersion.MINECRAFT_1_19, 19)));
        ArgumentPropertyRegistry.empty(ArgumentIdentifier.id("minecraft:nbt_tag", ArgumentIdentifier.mapSet(ProtocolVersion.MINECRAFT_1_19, 20)));
        ArgumentPropertyRegistry.empty(ArgumentIdentifier.id("minecraft:nbt_path", ArgumentIdentifier.mapSet(ProtocolVersion.MINECRAFT_1_19, 21)));
        ArgumentPropertyRegistry.empty(ArgumentIdentifier.id("minecraft:objective", ArgumentIdentifier.mapSet(ProtocolVersion.MINECRAFT_1_19, 22)));
        ArgumentPropertyRegistry.empty(ArgumentIdentifier.id("minecraft:objective_criteria", ArgumentIdentifier.mapSet(ProtocolVersion.MINECRAFT_1_19, 23)));
        ArgumentPropertyRegistry.empty(ArgumentIdentifier.id("minecraft:operation", ArgumentIdentifier.mapSet(ProtocolVersion.MINECRAFT_1_19, 24)));
        ArgumentPropertyRegistry.empty(ArgumentIdentifier.id("minecraft:particle", ArgumentIdentifier.mapSet(ProtocolVersion.MINECRAFT_1_19, 25)));
        ArgumentPropertyRegistry.empty(ArgumentIdentifier.id("minecraft:angle", ArgumentIdentifier.mapSet(ProtocolVersion.MINECRAFT_1_19, 26)));
        ArgumentPropertyRegistry.empty(ArgumentIdentifier.id("minecraft:rotation", ArgumentIdentifier.mapSet(ProtocolVersion.MINECRAFT_1_19, 27)));
        ArgumentPropertyRegistry.empty(ArgumentIdentifier.id("minecraft:scoreboard_slot", ArgumentIdentifier.mapSet(ProtocolVersion.MINECRAFT_1_19, 28)));
        ArgumentPropertyRegistry.empty(ArgumentIdentifier.id("minecraft:score_holder", ArgumentIdentifier.mapSet(ProtocolVersion.MINECRAFT_1_19, 29)), ByteArgumentPropertySerializer.BYTE);
        ArgumentPropertyRegistry.empty(ArgumentIdentifier.id("minecraft:swizzle", ArgumentIdentifier.mapSet(ProtocolVersion.MINECRAFT_1_19, 30)));
        ArgumentPropertyRegistry.empty(ArgumentIdentifier.id("minecraft:team", ArgumentIdentifier.mapSet(ProtocolVersion.MINECRAFT_1_19, 31)));
        ArgumentPropertyRegistry.empty(ArgumentIdentifier.id("minecraft:item_slot", ArgumentIdentifier.mapSet(ProtocolVersion.MINECRAFT_1_19, 32)));
        ArgumentPropertyRegistry.empty(ArgumentIdentifier.id("minecraft:resource_location", ArgumentIdentifier.mapSet(ProtocolVersion.MINECRAFT_1_19, 33)));
        ArgumentPropertyRegistry.empty(ArgumentIdentifier.id("minecraft:mob_effect", ArgumentIdentifier.mapSet(ProtocolVersion.MINECRAFT_1_19_3, -1), ArgumentIdentifier.mapSet(ProtocolVersion.MINECRAFT_1_19, 34)));
        ArgumentPropertyRegistry.empty(ArgumentIdentifier.id("minecraft:function", ArgumentIdentifier.mapSet(ProtocolVersion.MINECRAFT_1_19_3, 34), ArgumentIdentifier.mapSet(ProtocolVersion.MINECRAFT_1_19, 35)));
        ArgumentPropertyRegistry.empty(ArgumentIdentifier.id("minecraft:entity_anchor", ArgumentIdentifier.mapSet(ProtocolVersion.MINECRAFT_1_19_3, 35), ArgumentIdentifier.mapSet(ProtocolVersion.MINECRAFT_1_19, 36)));
        ArgumentPropertyRegistry.empty(ArgumentIdentifier.id("minecraft:int_range", ArgumentIdentifier.mapSet(ProtocolVersion.MINECRAFT_1_19_3, 36), ArgumentIdentifier.mapSet(ProtocolVersion.MINECRAFT_1_19, 37)));
        ArgumentPropertyRegistry.empty(ArgumentIdentifier.id("minecraft:float_range", ArgumentIdentifier.mapSet(ProtocolVersion.MINECRAFT_1_19_3, 37), ArgumentIdentifier.mapSet(ProtocolVersion.MINECRAFT_1_19, 38)));
        ArgumentPropertyRegistry.empty(ArgumentIdentifier.id("minecraft:item_enchantment", ArgumentIdentifier.mapSet(ProtocolVersion.MINECRAFT_1_19_3, -1), ArgumentIdentifier.mapSet(ProtocolVersion.MINECRAFT_1_19, 39)));
        ArgumentPropertyRegistry.empty(ArgumentIdentifier.id("minecraft:entity_summon", ArgumentIdentifier.mapSet(ProtocolVersion.MINECRAFT_1_19_3, -1), ArgumentIdentifier.mapSet(ProtocolVersion.MINECRAFT_1_19, 40)));
        ArgumentPropertyRegistry.empty(ArgumentIdentifier.id("minecraft:dimension", ArgumentIdentifier.mapSet(ProtocolVersion.MINECRAFT_1_19_3, 38), ArgumentIdentifier.mapSet(ProtocolVersion.MINECRAFT_1_19, 41)));
        ArgumentPropertyRegistry.empty(ArgumentIdentifier.id("minecraft:gamemode", ArgumentIdentifier.mapSet(ProtocolVersion.MINECRAFT_1_19_3, 39)));
        ArgumentPropertyRegistry.empty(ArgumentIdentifier.id("minecraft:time", ArgumentIdentifier.mapSet(ProtocolVersion.MINECRAFT_1_19_3, 40), ArgumentIdentifier.mapSet(ProtocolVersion.MINECRAFT_1_19, 42)), TimeArgumentSerializer.TIME);
        ArgumentPropertyRegistry.register(ArgumentIdentifier.id("minecraft:resource_or_tag", ArgumentIdentifier.mapSet(ProtocolVersion.MINECRAFT_1_19_3, 41), ArgumentIdentifier.mapSet(ProtocolVersion.MINECRAFT_1_19, 43)), RegistryKeyArgument.class, RegistryKeyArgumentSerializer.REGISTRY);
        ArgumentPropertyRegistry.register(ArgumentIdentifier.id("minecraft:resource_or_tag_key", ArgumentIdentifier.mapSet(ProtocolVersion.MINECRAFT_1_19_3, 42)), RegistryKeyArgumentList.ResourceOrTagKey.class, RegistryKeyArgumentList.ResourceOrTagKey.Serializer.REGISTRY);
        ArgumentPropertyRegistry.register(ArgumentIdentifier.id("minecraft:resource", ArgumentIdentifier.mapSet(ProtocolVersion.MINECRAFT_1_19_3, 43), ArgumentIdentifier.mapSet(ProtocolVersion.MINECRAFT_1_19, 44)), RegistryKeyArgument.class, RegistryKeyArgumentSerializer.REGISTRY);
        ArgumentPropertyRegistry.register(ArgumentIdentifier.id("minecraft:resource_key", ArgumentIdentifier.mapSet(ProtocolVersion.MINECRAFT_1_19_3, 44)), RegistryKeyArgumentList.ResourceKey.class, RegistryKeyArgumentList.ResourceKey.Serializer.REGISTRY);
        ArgumentPropertyRegistry.empty(ArgumentIdentifier.id("minecraft:template_mirror", ArgumentIdentifier.mapSet(ProtocolVersion.MINECRAFT_1_19, 45)));
        ArgumentPropertyRegistry.empty(ArgumentIdentifier.id("minecraft:template_rotation", ArgumentIdentifier.mapSet(ProtocolVersion.MINECRAFT_1_19, 46)));
        ArgumentPropertyRegistry.empty(ArgumentIdentifier.id("minecraft:heightmap", ArgumentIdentifier.mapSet(ProtocolVersion.MINECRAFT_1_19_4, 47)));
        ArgumentPropertyRegistry.empty(ArgumentIdentifier.id("minecraft:uuid", ArgumentIdentifier.mapSet(ProtocolVersion.MINECRAFT_1_19_4, 48), ArgumentIdentifier.mapSet(ProtocolVersion.MINECRAFT_1_19, 47)));
        ArgumentPropertyRegistry.register(ArgumentIdentifier.id("crossstitch:mod_argument", ArgumentIdentifier.mapSet(ProtocolVersion.MINECRAFT_1_19, -256)), ModArgumentProperty.class, ModArgumentPropertySerializer.MOD);
        ArgumentPropertyRegistry.empty(ArgumentIdentifier.id("minecraft:nbt", new ArgumentIdentifier.VersionSet[0]));
    }
}

