/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet.chat;

import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import com.velocitypowered.proxy.protocol.packet.chat.ChatType;
import io.netty.buffer.ByteBuf;
import net.kyori.adventure.text.Component;

public class SystemChat
implements MinecraftPacket {
    private Component component;
    private ChatType type;

    public SystemChat() {
    }

    public SystemChat(Component component, ChatType type) {
        this.component = component;
        this.type = type;
    }

    public ChatType getType() {
        return this.type;
    }

    public Component getComponent() {
        return this.component;
    }

    @Override
    public void decode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion protocolVersion) {
        this.component = ProtocolUtils.getJsonChatSerializer(protocolVersion).deserialize(ProtocolUtils.readString(buf));
        this.type = ChatType.values()[ProtocolUtils.readVarInt(buf)];
    }

    @Override
    public void encode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion protocolVersion) {
        block5: {
            block4: {
                ProtocolUtils.writeString(buf, (CharSequence)ProtocolUtils.getJsonChatSerializer(protocolVersion).serialize(this.component));
                if (protocolVersion.compareTo(ProtocolVersion.MINECRAFT_1_19_1) < 0) break block4;
                switch (this.type) {
                    case SYSTEM: {
                        buf.writeBoolean(false);
                        break block5;
                    }
                    case GAME_INFO: {
                        buf.writeBoolean(true);
                        break block5;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid chat type");
                    }
                }
            }
            ProtocolUtils.writeVarInt(buf, this.type.getId());
        }
    }

    @Override
    public boolean handle(MinecraftSessionHandler handler) {
        return handler.handle(this);
    }
}

