/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.ansi;

import java.util.Arrays;
import java.util.Objects;
import net.kyori.ansi.ANSIComponentRenderer;
import net.kyori.ansi.ColorLevel;
import net.kyori.ansi.Formats;
import net.kyori.ansi.StyleOps;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class ANSIComponentRendererImpl<S>
implements ANSIComponentRenderer<S> {
    private static final int MAX_DEPTH = 128;
    private static final int UNSET = -1;
    private final StyleOps<S> ops;
    private final ColorLevel color;
    protected StringBuilder builder;
    private final Frame active = new Frame();
    private Frame[] styles = new Frame[8];
    private int head = -1;
    private boolean stylePending;

    protected ANSIComponentRendererImpl(StyleOps<S> ops, ColorLevel colorLevel) {
        this.ops = Objects.requireNonNull(ops, "ops");
        this.color = Objects.requireNonNull(colorLevel, "colorLevel");
        this.active.clear();
    }

    @Nullable
    private Frame peek() {
        if (this.head < 0) {
            return null;
        }
        return this.styles[this.head];
    }

    private Frame push() {
        Frame frame;
        int idx;
        if ((idx = ++this.head) >= 128) {
            throw new IllegalStateException("Too many styles! Maximum depth of 128 exceeded");
        }
        if (idx >= this.styles.length) {
            this.styles = Arrays.copyOf(this.styles, this.styles.length * 2);
        }
        if ((frame = this.styles[idx]) == null) {
            frame = this.styles[idx] = new Frame();
        }
        if (idx > 0) {
            frame.set(this.styles[idx - 1]);
        } else {
            frame.clear();
        }
        return frame;
    }

    private Frame pop() {
        if (this.head < 0) {
            throw new IllegalStateException("Tried to pop beyond what was pushed!");
        }
        return this.styles[this.head--];
    }

    @Override
    @NotNull
    public ANSIComponentRenderer<S> pushStyle(@NotNull S style) {
        Frame frame = this.push();
        frame.apply(style, this.ops);
        this.stylePending = true;
        return this;
    }

    @Override
    @NotNull
    public ANSIComponentRenderer<S> text(@NotNull String text) {
        this.appendUpdatedStyle();
        this.builder.append(text);
        return this;
    }

    private void appendUpdatedStyle() {
        if (this.stylePending) {
            Frame style = this.peek();
            this.printDifferences(this.active, style);
            if (style == null) {
                this.active.clear();
            } else {
                this.active.set(style);
            }
            this.stylePending = false;
        }
    }

    @Override
    @NotNull
    public ANSIComponentRenderer<S> popStyle(@NotNull S style) {
        this.pop();
        this.stylePending = true;
        return this;
    }

    @Override
    @NotNull
    public ANSIComponentRenderer<S> complete() {
        if (this.head != -1) {
            throw new IllegalStateException("Ended build with unbalanced stack. Remaining items are: " + Arrays.toString(Arrays.copyOf(this.styles, this.head + 1)));
        }
        this.appendUpdatedStyle();
        return this;
    }

    private void printDifferences(@NotNull Frame active, @Nullable Frame target) {
        if (this.color == ColorLevel.NONE) {
            return;
        }
        StringBuilder builder = this.builder;
        if (target == null) {
            if (active.style != 0 || active.color != -1) {
                Formats.emit(Formats.reset(), builder);
            }
        } else if (active.style != target.style || target.color == -1) {
            if (active.style != 0 || active.color != -1 && target.color == -1) {
                Formats.emit(Formats.reset(), builder);
            }
            if ((target.style & 1) != 0) {
                Formats.emit(Formats.bold(true), builder);
            }
            if ((target.style & 2) != 0) {
                Formats.emit(Formats.italics(true), builder);
            }
            if ((target.style & 4) != 0) {
                Formats.emit(Formats.obfuscated(true), builder);
            }
            if ((target.style & 8) != 0) {
                Formats.emit(Formats.strikethrough(true), builder);
            }
            if ((target.style & 0x10) != 0) {
                Formats.emit(Formats.underlined(true), builder);
            }
            if (target.color != -1) {
                Formats.emit(this.color.determineEscape(target.color), builder);
            }
        } else if (active.color != target.color) {
            Formats.emit(this.color.determineEscape(target.color), builder);
        }
    }

    static final class ToString<S>
    extends ANSIComponentRendererImpl<S>
    implements ANSIComponentRenderer.ToString<S> {
        ToString(StyleOps<S> ops, ColorLevel colorLevel) {
            super(ops, colorLevel);
            this.builder = new StringBuilder();
        }

        @Override
        @NotNull
        public String asString() {
            String output = this.builder.toString();
            this.builder.delete(0, this.builder.length());
            return output;
        }
    }

    static final class ToStringBuilder<S>
    extends ANSIComponentRendererImpl<S>
    implements ANSIComponentRenderer.ToStringBuilder<S> {
        ToStringBuilder(StyleOps<S> ops, ColorLevel colorLevel) {
            super(ops, colorLevel);
        }

        @Override
        public void builder(@NotNull StringBuilder builder) {
            this.builder = Objects.requireNonNull(builder, "builder");
        }

        @Override
        @NotNull
        public StringBuilder builder() {
            if (this.builder == null) {
                throw new IllegalStateException("String builder has not yet been initialized");
            }
            return this.builder;
        }
    }

    static final class Frame {
        static final int BOLD = 1;
        static final int ITALICS = 2;
        static final int OBFUSCATED = 4;
        static final int STRIKETHROUGH = 8;
        static final int UNDERLINED = 16;
        int color;
        int style;

        Frame() {
        }

        void set(@NotNull Frame other) {
            this.color = other.color;
            this.style = other.style;
        }

        <S> void apply(@NotNull S that, @NotNull StyleOps<S> ops) {
            int color = ops.color(that);
            if (color != -1) {
                this.color = ops.color(that);
            }
            this.apply(1, ops.bold(that));
            this.apply(2, ops.italics(that));
            this.apply(4, ops.obfuscated(that));
            this.apply(8, ops.strikethrough(that));
            this.apply(16, ops.underlined(that));
        }

        private void apply(int flag, StyleOps.State state) {
            switch (state) {
                case TRUE: {
                    this.style |= flag;
                    break;
                }
                case FALSE: {
                    this.style &= ~flag;
                    break;
                }
            }
        }

        public void clear() {
            this.color = -1;
            this.style = 0;
        }
    }
}

