/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.connection.client;

import com.google.common.base.Preconditions;
import com.velocitypowered.api.event.connection.DisconnectEvent;
import com.velocitypowered.api.event.connection.LoginEvent;
import com.velocitypowered.api.event.connection.PostLoginEvent;
import com.velocitypowered.api.event.permission.PermissionsSetupEvent;
import com.velocitypowered.api.event.player.CookieReceiveEvent;
import com.velocitypowered.api.event.player.GameProfileRequestEvent;
import com.velocitypowered.api.event.player.PlayerChooseInitialServerEvent;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.api.permission.PermissionFunction;
import com.velocitypowered.api.proxy.crypto.IdentifiedKey;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import com.velocitypowered.api.util.GameProfile;
import com.velocitypowered.api.util.UuidUtils;
import com.velocitypowered.proxy.VelocityServer;
import com.velocitypowered.proxy.config.PlayerInfoForwarding;
import com.velocitypowered.proxy.config.VelocityConfiguration;
import com.velocitypowered.proxy.connection.MinecraftConnection;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.connection.client.ClientConfigSessionHandler;
import com.velocitypowered.proxy.connection.client.ConnectedPlayer;
import com.velocitypowered.proxy.connection.client.InitialConnectSessionHandler;
import com.velocitypowered.proxy.connection.client.LoginInboundConnection;
import com.velocitypowered.proxy.crypto.IdentifiedKeyImpl;
import com.velocitypowered.proxy.protocol.StateRegistry;
import com.velocitypowered.proxy.protocol.packet.LoginAcknowledgedPacket;
import com.velocitypowered.proxy.protocol.packet.ServerLoginSuccessPacket;
import com.velocitypowered.proxy.protocol.packet.ServerboundCookieResponsePacket;
import com.velocitypowered.proxy.protocol.packet.SetCompressionPacket;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public class AuthSessionHandler
implements MinecraftSessionHandler {
    private static final Logger logger = LogManager.getLogger(AuthSessionHandler.class);
    private final VelocityServer server;
    private final MinecraftConnection mcConnection;
    private final LoginInboundConnection inbound;
    private GameProfile profile;
    private @MonotonicNonNull ConnectedPlayer connectedPlayer;
    private final boolean onlineMode;
    private State loginState = State.START;

    AuthSessionHandler(VelocityServer server, LoginInboundConnection inbound, GameProfile profile, boolean onlineMode) {
        this.server = Preconditions.checkNotNull(server, "server");
        this.inbound = Preconditions.checkNotNull(inbound, "inbound");
        this.profile = Preconditions.checkNotNull(profile, "profile");
        this.onlineMode = onlineMode;
        this.mcConnection = inbound.delegatedConnection();
    }

    @Override
    public void activated() {
        this.profile = this.mcConnection.getType().addGameProfileTokensIfRequired(this.profile, this.server.getConfiguration().getPlayerInfoForwardingMode());
        GameProfileRequestEvent profileRequestEvent = new GameProfileRequestEvent(this.inbound, this.profile, this.onlineMode);
        GameProfile finalProfile = this.profile;
        ((CompletableFuture)this.server.getEventManager().fire(profileRequestEvent).thenComposeAsync(profileEvent -> {
            ConnectedPlayer player;
            if (this.mcConnection.isClosed()) {
                return CompletableFuture.completedFuture(null);
            }
            this.connectedPlayer = player = new ConnectedPlayer(this.server, profileEvent.getGameProfile(), this.mcConnection, this.inbound.getVirtualHost().orElse(null), this.onlineMode, this.inbound.getIdentifiedKey());
            if (!this.server.canRegisterConnection(player)) {
                player.disconnect0(Component.translatable("velocity.error.already-connected-proxy", (TextColor)NamedTextColor.RED), true);
                return CompletableFuture.completedFuture(null);
            }
            logger.info("{} has connected", (Object)player);
            return this.server.getEventManager().fire(new PermissionsSetupEvent(player, ConnectedPlayer.DEFAULT_PERMISSIONS)).thenAcceptAsync(event -> {
                if (!this.mcConnection.isClosed()) {
                    PermissionFunction function = event.createFunction(player);
                    if (function == null) {
                        logger.error("A plugin permission provider {} provided an invalid permission function for player {}. This is a bug in the plugin, not in Velocity. Falling back to the default permission function.", (Object)event.getProvider().getClass().getName(), (Object)player.getUsername());
                    } else {
                        player.setPermissionFunction(function);
                    }
                    this.startLoginCompletion(player);
                }
            }, (Executor)this.mcConnection.eventLoop());
        }, (Executor)this.mcConnection.eventLoop())).exceptionally(ex -> {
            logger.error("Exception during connection of {}", (Object)finalProfile, ex);
            return null;
        });
    }

    private void startLoginCompletion(ConnectedPlayer player) {
        int threshold = this.server.getConfiguration().getCompressionThreshold();
        if (threshold >= 0 && this.mcConnection.getProtocolVersion().noLessThan(ProtocolVersion.MINECRAFT_1_8)) {
            this.mcConnection.write(new SetCompressionPacket(threshold));
            this.mcConnection.setCompressionThreshold(threshold);
        }
        VelocityConfiguration configuration = this.server.getConfiguration();
        UUID playerUniqueId = player.getUniqueId();
        if (configuration.getPlayerInfoForwardingMode() == PlayerInfoForwarding.NONE) {
            playerUniqueId = UuidUtils.generateOfflinePlayerUuid(player.getUsername());
        }
        if (player.getIdentifiedKey() != null) {
            IdentifiedKey playerKey = player.getIdentifiedKey();
            if (playerKey.getSignatureHolder() == null) {
                if (playerKey instanceof IdentifiedKeyImpl) {
                    IdentifiedKeyImpl unlinkedKey = (IdentifiedKeyImpl)playerKey;
                    if (!unlinkedKey.internalAddHolder(player.getUniqueId())) {
                        if (this.onlineMode) {
                            this.inbound.disconnect(Component.translatable("multiplayer.disconnect.invalid_public_key"));
                            return;
                        }
                        logger.warn("Key for player {} could not be verified!", (Object)player.getUsername());
                    }
                } else {
                    logger.warn("A custom key type has been set for player " + player.getUsername());
                }
            } else if (!Objects.equals(playerKey.getSignatureHolder(), playerUniqueId)) {
                logger.warn("UUID for Player {} mismatches! Chat/Commands signatures will not work correctly for this player!", (Object)player.getUsername());
            }
        }
        this.completeLoginProtocolPhaseAndInitialize(player);
    }

    @Override
    public boolean handle(LoginAcknowledgedPacket packet) {
        if (this.loginState != State.SUCCESS_SENT) {
            this.inbound.disconnect(Component.translatable("multiplayer.disconnect.invalid_player_data"));
        } else {
            this.loginState = State.ACKNOWLEDGED;
            this.mcConnection.setActiveSessionHandler(StateRegistry.CONFIG, new ClientConfigSessionHandler(this.server, this.connectedPlayer));
            ((CompletableFuture)this.server.getEventManager().fire(new PostLoginEvent(this.connectedPlayer)).thenCompose(ignored -> this.connectToInitialServer(this.connectedPlayer))).exceptionally(ex -> {
                logger.error("Exception while connecting {} to initial server", (Object)this.connectedPlayer, ex);
                return null;
            });
        }
        return true;
    }

    @Override
    public boolean handle(ServerboundCookieResponsePacket packet) {
        this.server.getEventManager().fire(new CookieReceiveEvent(this.connectedPlayer, packet.getKey(), packet.getPayload())).thenAcceptAsync(event -> {
            if (event.getResult().isAllowed()) {
                throw new IllegalStateException("A cookie was requested by a proxy plugin in login phase but the response wasn't handled");
            }
        }, (Executor)this.mcConnection.eventLoop());
        return true;
    }

    private void completeLoginProtocolPhaseAndInitialize(ConnectedPlayer player) {
        this.mcConnection.setAssociation(player);
        ((CompletableFuture)this.server.getEventManager().fire(new LoginEvent(player)).thenAcceptAsync(event -> {
            if (this.mcConnection.isClosed()) {
                this.server.getEventManager().fireAndForget(new DisconnectEvent(player, DisconnectEvent.LoginStatus.CANCELLED_BY_USER_BEFORE_COMPLETE));
                return;
            }
            Optional<Component> reason = event.getResult().getReasonComponent();
            if (reason.isPresent()) {
                player.disconnect0(reason.get(), true);
            } else {
                if (!this.server.registerConnection(player)) {
                    player.disconnect0(Component.translatable("velocity.error.already-connected-proxy"), true);
                    return;
                }
                ServerLoginSuccessPacket success = new ServerLoginSuccessPacket();
                success.setUsername(player.getUsername());
                success.setProperties(player.getGameProfileProperties());
                success.setUuid(player.getUniqueId());
                this.mcConnection.write(success);
                this.loginState = State.SUCCESS_SENT;
                if (this.inbound.getProtocolVersion().lessThan(ProtocolVersion.MINECRAFT_1_20_2)) {
                    this.loginState = State.ACKNOWLEDGED;
                    this.mcConnection.setActiveSessionHandler(StateRegistry.PLAY, new InitialConnectSessionHandler(player, this.server));
                    ((CompletableFuture)this.server.getEventManager().fire(new PostLoginEvent(player)).thenCompose(ignored -> this.connectToInitialServer(player))).exceptionally(ex -> {
                        logger.error("Exception while connecting {} to initial server", (Object)player, ex);
                        return null;
                    });
                }
            }
        }, (Executor)this.mcConnection.eventLoop())).exceptionally(ex -> {
            logger.error("Exception while completing login initialisation phase for {}", (Object)player, ex);
            return null;
        });
    }

    private CompletableFuture<Void> connectToInitialServer(ConnectedPlayer player) {
        Optional<RegisteredServer> initialFromConfig = player.getNextServerToTry();
        PlayerChooseInitialServerEvent event = new PlayerChooseInitialServerEvent(player, initialFromConfig.orElse(null));
        return this.server.getEventManager().fire(event).thenRunAsync(() -> {
            Optional<RegisteredServer> toTry = event.getInitialServer();
            if (toTry.isEmpty()) {
                player.disconnect0(Component.translatable("velocity.error.no-available-servers", (TextColor)NamedTextColor.RED), true);
                return;
            }
            player.createConnectionRequest(toTry.get()).fireAndForget();
        }, this.mcConnection.eventLoop());
    }

    @Override
    public void handleUnknown(ByteBuf buf) {
        this.mcConnection.close(true);
    }

    @Override
    public void disconnected() {
        if (this.connectedPlayer != null) {
            this.connectedPlayer.teardown();
        }
        this.inbound.cleanup();
    }

    static enum State {
        START,
        SUCCESS_SENT,
        ACKNOWLEDGED;

    }
}

