/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet.chat;

import com.velocitypowered.proxy.connection.MinecraftConnection;
import com.velocitypowered.proxy.connection.client.ConnectedPlayer;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.packet.chat.ChatAcknowledgementPacket;
import com.velocitypowered.proxy.protocol.packet.chat.LastSeenMessages;
import io.netty.channel.ChannelFuture;
import java.time.Instant;
import java.util.BitSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ChatQueue {
    private final Object internalLock = new Object();
    private final ConnectedPlayer player;
    private final ChatState chatState = new ChatState();
    private CompletableFuture<Void> head = CompletableFuture.completedFuture(null);

    public ChatQueue(ConnectedPlayer player) {
        this.player = player;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueTask(Task task) {
        Object object = this.internalLock;
        synchronized (object) {
            MinecraftConnection smc = this.player.ensureAndGetCurrentServer().ensureConnected();
            this.head = this.head.thenCompose(v -> {
                try {
                    return task.update(this.chatState, smc).exceptionally(ignored -> null);
                }
                catch (Throwable ignored2) {
                    return CompletableFuture.completedFuture(null);
                }
            });
        }
    }

    public void queuePacket(Function<LastSeenMessages, CompletableFuture<MinecraftPacket>> nextPacket, @Nullable Instant timestamp, @Nullable LastSeenMessages lastSeenMessages) {
        this.queueTask((chatState, smc) -> {
            LastSeenMessages newLastSeenMessages = chatState.updateFromMessage(timestamp, lastSeenMessages);
            return ((CompletableFuture)nextPacket.apply(newLastSeenMessages)).thenCompose(packet -> ChatQueue.writePacket(packet, smc));
        });
    }

    public <T extends MinecraftPacket> void queuePacket(Function<ChatState, T> packetFunction) {
        this.queueTask((chatState, smc) -> {
            MinecraftPacket packet = (MinecraftPacket)packetFunction.apply(chatState);
            return ChatQueue.writePacket(packet, smc);
        });
    }

    public void handleAcknowledgement(int offset) {
        this.queueTask((chatState, smc) -> {
            int ackCountToForward = chatState.accumulateAckCount(offset);
            if (ackCountToForward > 0) {
                return ChatQueue.writePacket(new ChatAcknowledgementPacket(ackCountToForward), smc);
            }
            return CompletableFuture.completedFuture(null);
        });
    }

    private static <T extends MinecraftPacket> CompletableFuture<Void> writePacket(T packet, MinecraftConnection smc) {
        return CompletableFuture.runAsync(() -> {
            ChannelFuture future;
            if (!smc.isClosed() && (future = smc.write(packet)) != null) {
                future.awaitUninterruptibly();
            }
        }, smc.eventLoop());
    }

    public static class ChatState {
        private static final int MINIMUM_DELAYED_ACK_COUNT = 20;
        private static final BitSet DUMMY_LAST_SEEN_MESSAGES = new BitSet();
        public volatile Instant lastTimestamp = Instant.EPOCH;
        private volatile BitSet lastSeenMessages = new BitSet();
        private final AtomicInteger delayedAckCount = new AtomicInteger();

        private ChatState() {
        }

        public @Nullable LastSeenMessages updateFromMessage(@Nullable Instant timestamp, @Nullable LastSeenMessages lastSeenMessages) {
            if (timestamp != null) {
                this.lastTimestamp = timestamp;
            }
            if (lastSeenMessages != null) {
                int delayedAckCount = this.delayedAckCount.getAndSet(0);
                this.lastSeenMessages = lastSeenMessages.getAcknowledged();
                return lastSeenMessages.offset(delayedAckCount);
            }
            return null;
        }

        public int accumulateAckCount(int ackCount) {
            int delayedAckCount = this.delayedAckCount.addAndGet(ackCount);
            int ackCountToForward = delayedAckCount - 20;
            if (ackCountToForward >= 20) {
                this.lastSeenMessages = DUMMY_LAST_SEEN_MESSAGES;
                this.delayedAckCount.set(20);
                return ackCountToForward;
            }
            return 0;
        }

        public LastSeenMessages createLastSeen() {
            return new LastSeenMessages(0, this.lastSeenMessages);
        }
    }

    private static interface Task {
        public CompletableFuture<Void> update(ChatState var1, MinecraftConnection var2);
    }
}

