/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.util.ratelimit;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Ticker;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.velocitypowered.proxy.util.ratelimit.Ratelimiter;
import java.net.InetAddress;
import java.util.concurrent.TimeUnit;

public class CaffeineCacheRatelimiter
implements Ratelimiter {
    private final Cache<InetAddress, Long> expiringCache;
    private final long timeoutNanos;

    CaffeineCacheRatelimiter(long time, TimeUnit unit) {
        this(time, unit, Ticker.systemTicker());
    }

    @VisibleForTesting
    CaffeineCacheRatelimiter(long time, TimeUnit unit, Ticker ticker) {
        Preconditions.checkNotNull(unit, "unit");
        Preconditions.checkNotNull(ticker, "ticker");
        this.timeoutNanos = unit.toNanos(time);
        this.expiringCache = Caffeine.newBuilder().ticker(ticker).expireAfterWrite(time, unit).build();
    }

    @Override
    public boolean attempt(InetAddress address) {
        Preconditions.checkNotNull(address, "address");
        long expectedNewValue = System.nanoTime() + this.timeoutNanos;
        long last = this.expiringCache.get(address, address1 -> expectedNewValue);
        return expectedNewValue == last;
    }
}

