/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.api.event.command;

import com.google.common.base.Preconditions;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.event.ResultedEvent;
import com.velocitypowered.api.event.annotation.AwaitingEvent;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@AwaitingEvent
public final class CommandExecuteEvent
implements ResultedEvent<CommandResult> {
    private final CommandSource commandSource;
    private final String command;
    private CommandResult result;
    private InvocationInfo invocationInfo;

    public CommandExecuteEvent(CommandSource commandSource, String command) {
        this(commandSource, command, new InvocationInfo(SignedState.UNSUPPORTED, Source.API));
    }

    public CommandExecuteEvent(CommandSource commandSource, String command, InvocationInfo invocationInfo) {
        this.commandSource = Preconditions.checkNotNull(commandSource, "commandSource");
        this.command = Preconditions.checkNotNull(command, "command");
        this.result = CommandResult.allowed();
        this.invocationInfo = invocationInfo;
    }

    public CommandSource getCommandSource() {
        return this.commandSource;
    }

    public String getCommand() {
        return this.command;
    }

    public InvocationInfo getInvocationInfo() {
        return this.invocationInfo;
    }

    @Override
    public CommandResult getResult() {
        return this.result;
    }

    @Override
    public void setResult(@NonNull CommandResult result) {
        this.result = Preconditions.checkNotNull(result, "result");
    }

    public String toString() {
        return "CommandExecuteEvent{commandSource=" + this.commandSource + ", command=" + this.command + ", result=" + this.result + "}";
    }

    public record InvocationInfo(SignedState signedState, Source source) {
    }

    public static enum SignedState {
        SIGNED_WITH_ARGS,
        SIGNED_WITHOUT_ARGS,
        UNSIGNED,
        UNSUPPORTED;

    }

    public static enum Source {
        PLAYER,
        API;

    }

    public static final class CommandResult
    implements ResultedEvent.Result {
        private static final CommandResult ALLOWED = new CommandResult(true, false, null);
        private static final CommandResult DENIED = new CommandResult(false, false, null);
        private static final CommandResult FORWARD_TO_SERVER = new CommandResult(false, true, null);
        private final @Nullable String command;
        private final boolean status;
        private final boolean forward;

        private CommandResult(boolean status, boolean forward, @Nullable String command) {
            this.status = status;
            this.forward = forward;
            this.command = command;
        }

        public Optional<String> getCommand() {
            return Optional.ofNullable(this.command);
        }

        public boolean isForwardToServer() {
            return this.forward;
        }

        @Override
        public boolean isAllowed() {
            return this.status;
        }

        public String toString() {
            return this.status ? "allowed" : "denied";
        }

        public static CommandResult allowed() {
            return ALLOWED;
        }

        public static CommandResult denied() {
            return DENIED;
        }

        public static CommandResult forwardToServer() {
            return FORWARD_TO_SERVER;
        }

        public static CommandResult forwardToServer(@NonNull String newCommand) {
            Preconditions.checkNotNull(newCommand, "newCommand");
            return new CommandResult(false, true, newCommand);
        }

        public static CommandResult command(@NonNull String newCommand) {
            Preconditions.checkNotNull(newCommand, "newCommand");
            return new CommandResult(true, false, newCommand);
        }
    }
}

