/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.netty;

import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import com.velocitypowered.proxy.protocol.StateRegistry;
import com.velocitypowered.proxy.protocol.netty.MinecraftDecoder;
import com.velocitypowered.proxy.util.except.QuietDecoderException;
import com.velocitypowered.proxy.util.except.QuietRuntimeException;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.CorruptedFrameException;
import io.netty.util.ByteProcessor;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MinecraftVarintFrameDecoder
extends ByteToMessageDecoder {
    private static final Logger LOGGER = LogManager.getLogger(MinecraftVarintFrameDecoder.class);
    private static final QuietRuntimeException FRAME_DECODER_FAILED = new QuietRuntimeException("A packet frame decoder failed. For more information, launch Velocity with -Dvelocity.packet-decode-logging=true to see more.");
    private static final QuietDecoderException BAD_PACKET_LENGTH = new QuietDecoderException("Bad packet length");
    private static final QuietDecoderException VARINT_TOO_BIG = new QuietDecoderException("VarInt too big");
    private static final QuietDecoderException UNKNOWN_PACKET = new QuietDecoderException("Unknown packet");
    private final ProtocolUtils.Direction direction;
    private final StateRegistry.PacketRegistry.ProtocolRegistry registry;
    private StateRegistry state;

    public MinecraftVarintFrameDecoder(ProtocolUtils.Direction direction) {
        this.direction = direction;
        this.registry = StateRegistry.HANDSHAKE.getProtocolRegistry(direction, ProtocolVersion.MINIMUM_VERSION);
        this.state = StateRegistry.HANDSHAKE;
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (!ctx.channel().isActive()) {
            in.clear();
            return;
        }
        int packetStart = in.forEachByte(ByteProcessor.FIND_NON_NUL);
        if (packetStart == -1) {
            in.clear();
            return;
        }
        in.readerIndex(packetStart);
        in.markReaderIndex();
        int preIndex = in.readerIndex();
        int length = MinecraftVarintFrameDecoder.readRawVarInt21(in);
        if (preIndex == in.readerIndex()) {
            return;
        }
        if (length < 0) {
            throw BAD_PACKET_LENGTH;
        }
        if (length > 0 && this.state == StateRegistry.HANDSHAKE && this.direction == ProtocolUtils.Direction.SERVERBOUND) {
            StateRegistry.PacketRegistry.ProtocolRegistry registry = this.state.getProtocolRegistry(this.direction, ProtocolVersion.MINIMUM_VERSION);
            int index = in.readerIndex();
            int packetId = MinecraftVarintFrameDecoder.readRawVarInt21(in);
            if (index == in.readerIndex()) {
                in.resetReaderIndex();
                return;
            }
            int payloadLength = length - ProtocolUtils.varIntBytes(packetId);
            MinecraftPacket packet = registry.createPacket(packetId);
            if (packet == null) {
                throw UNKNOWN_PACKET;
            }
            int expectedMinLen = packet.expectedMinLength(in, this.direction, registry.version);
            int expectedMaxLen = packet.expectedMaxLength(in, this.direction, registry.version);
            if (expectedMaxLen != -1 && payloadLength > expectedMaxLen) {
                throw this.handleOverflow(packet, expectedMaxLen, in.readableBytes());
            }
            if (payloadLength < expectedMinLen) {
                throw this.handleUnderflow(packet, expectedMaxLen, in.readableBytes());
            }
            in.readerIndex(index);
        }
        if (length > 0) {
            if (in.readableBytes() < length) {
                in.resetReaderIndex();
            } else {
                out.add(in.readRetainedSlice(length));
            }
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (MinecraftDecoder.DEBUG) {
            LOGGER.atWarn().withThrowable(cause).log("Exception caught while decoding frame for {}", (Object)ctx.channel().remoteAddress());
        }
        super.exceptionCaught(ctx, cause);
    }

    private static int readRawVarInt21(ByteBuf buffer) {
        if (buffer.readableBytes() < 4) {
            return MinecraftVarintFrameDecoder.readRawVarintSmallBuf(buffer);
        }
        int wholeOrMore = buffer.getIntLE(buffer.readerIndex());
        int atStop = ~wholeOrMore & 0x808080;
        if (atStop == 0) {
            throw VARINT_TOO_BIG;
        }
        int bitsToKeep = Integer.numberOfTrailingZeros(atStop) + 1;
        buffer.skipBytes(bitsToKeep >> 3);
        int preservedBytes = wholeOrMore & (atStop ^ atStop - 1);
        preservedBytes = preservedBytes & 0x7F007F | (preservedBytes & 0x7F00) >> 1;
        preservedBytes = preservedBytes & 0x3FFF | (preservedBytes & 0x3FFF0000) >> 2;
        return preservedBytes;
    }

    private static int readRawVarintSmallBuf(ByteBuf buffer) {
        if (!buffer.isReadable()) {
            return 0;
        }
        buffer.markReaderIndex();
        byte tmp = buffer.readByte();
        if (tmp >= 0) {
            return tmp;
        }
        int result = tmp & 0x7F;
        if (!buffer.isReadable()) {
            buffer.resetReaderIndex();
            return 0;
        }
        tmp = buffer.readByte();
        if (tmp >= 0) {
            return result | tmp << 7;
        }
        result |= (tmp & 0x7F) << 7;
        if (!buffer.isReadable()) {
            buffer.resetReaderIndex();
            return 0;
        }
        tmp = buffer.readByte();
        if (tmp >= 0) {
            return result | tmp << 14;
        }
        return result | (tmp & 0x7F) << 14;
    }

    private Exception handleOverflow(MinecraftPacket packet, int expected, int actual) {
        if (MinecraftDecoder.DEBUG) {
            return new CorruptedFrameException("Packet sent for " + packet.getClass() + " was too big (expected " + expected + " bytes, got " + actual + " bytes)");
        }
        return FRAME_DECODER_FAILED;
    }

    private Exception handleUnderflow(MinecraftPacket packet, int expected, int actual) {
        if (MinecraftDecoder.DEBUG) {
            return new CorruptedFrameException("Packet sent for " + packet.getClass() + " was too small (expected " + expected + " bytes, got " + actual + " bytes)");
        }
        return FRAME_DECODER_FAILED;
    }

    public void setState(StateRegistry stateRegistry) {
        this.state = stateRegistry;
    }
}

