/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet;

import com.velocitypowered.api.network.HandshakeIntent;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import io.netty.buffer.ByteBuf;

public class HandshakePacket
implements MinecraftPacket {
    private static final int MAXIMUM_HOSTNAME_LENGTH = 255 + "\u0000FML\u0000".length() + 1;
    private ProtocolVersion protocolVersion;
    private String serverAddress = "";
    private int port;
    private HandshakeIntent intent;
    private int nextStatus;

    public ProtocolVersion getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setProtocolVersion(ProtocolVersion protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public void setServerAddress(String serverAddress) {
        this.serverAddress = serverAddress;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getNextStatus() {
        return this.nextStatus;
    }

    public void setIntent(HandshakeIntent intent) {
        this.intent = intent;
        this.nextStatus = intent.id();
    }

    public HandshakeIntent getIntent() {
        return this.intent;
    }

    public String toString() {
        return "Handshake{protocolVersion=" + this.protocolVersion + ", serverAddress='" + this.serverAddress + "', port=" + this.port + ", nextStatus=" + this.nextStatus + "}";
    }

    @Override
    public void decode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion ignored) {
        int realProtocolVersion = ProtocolUtils.readVarInt(buf);
        this.protocolVersion = ProtocolVersion.getProtocolVersion(realProtocolVersion);
        this.serverAddress = ProtocolUtils.readString(buf, MAXIMUM_HOSTNAME_LENGTH);
        this.port = buf.readUnsignedShort();
        this.nextStatus = ProtocolUtils.readVarInt(buf);
        this.intent = HandshakeIntent.getById(this.nextStatus);
    }

    @Override
    public void encode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion ignored) {
        ProtocolUtils.writeVarInt(buf, this.protocolVersion.getProtocol());
        ProtocolUtils.writeString(buf, this.serverAddress);
        buf.writeShort(this.port);
        ProtocolUtils.writeVarInt(buf, this.nextStatus);
    }

    @Override
    public boolean handle(MinecraftSessionHandler handler) {
        return handler.handle(this);
    }

    @Override
    public int expectedMinLength(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion version) {
        return 7;
    }

    @Override
    public int expectedMaxLength(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion version) {
        return 9 + MAXIMUM_HOSTNAME_LENGTH * 3;
    }
}

