/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import com.velocitypowered.api.proxy.messages.LegacyChannelIdentifier;
import com.velocitypowered.api.proxy.messages.MinecraftChannelIdentifier;
import com.velocitypowered.api.util.ProxyVersion;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import com.velocitypowered.proxy.protocol.netty.MinecraftDecoder;
import com.velocitypowered.proxy.protocol.packet.PluginMessagePacket;
import com.velocitypowered.proxy.util.except.QuietDecoderException;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;

public final class PluginMessageUtil {
    private static final String BRAND_CHANNEL_LEGACY = "MC|Brand";
    private static final String BRAND_CHANNEL = "minecraft:brand";
    private static final String REGISTER_CHANNEL_LEGACY = "REGISTER";
    private static final String REGISTER_CHANNEL = "minecraft:register";
    private static final String UNREGISTER_CHANNEL_LEGACY = "UNREGISTER";
    private static final String UNREGISTER_CHANNEL = "minecraft:unregister";
    private static final QuietDecoderException ILLEGAL_CHANNEL = new QuietDecoderException("Illegal channel");
    private static final Pattern INVALID_IDENTIFIER_REGEX = Pattern.compile("[^a-z0-9\\-_]*");

    private PluginMessageUtil() {
        throw new AssertionError();
    }

    public static boolean isMcBrand(PluginMessagePacket message) {
        Preconditions.checkNotNull(message, "message");
        return message.getChannel().equals(BRAND_CHANNEL_LEGACY) || message.getChannel().equals(BRAND_CHANNEL);
    }

    public static boolean isRegister(PluginMessagePacket message) {
        Preconditions.checkNotNull(message, "message");
        return message.getChannel().equals(REGISTER_CHANNEL_LEGACY) || message.getChannel().equals(REGISTER_CHANNEL);
    }

    public static boolean isUnregister(PluginMessagePacket message) {
        Preconditions.checkNotNull(message, "message");
        return message.getChannel().equals(UNREGISTER_CHANNEL_LEGACY) || message.getChannel().equals(UNREGISTER_CHANNEL);
    }

    public static List<ChannelIdentifier> getChannels(int existingChannels, PluginMessagePacket message, ProtocolVersion protocolVersion) {
        Preconditions.checkNotNull(message, "message");
        Preconditions.checkArgument(PluginMessageUtil.isRegister(message) || PluginMessageUtil.isUnregister(message), "Unknown channel type %s", (Object)message.getChannel());
        if (!message.content().isReadable()) {
            return ImmutableList.of();
        }
        String payload = message.content().toString(StandardCharsets.UTF_8);
        Preconditions.checkArgument(payload.length() <= Short.MAX_VALUE, "payload too long: %s", payload.length());
        String[] channels = payload.split("\u0000");
        Preconditions.checkArgument(existingChannels + channels.length <= 1024, "too many channels: %s + %s > %s", (Object)existingChannels, (Object)channels.length, (Object)1024);
        ImmutableList.Builder channelIdentifiers = ImmutableList.builderWithExpectedSize(channels.length);
        try {
            for (String channel : channels) {
                if (protocolVersion.noLessThan(ProtocolVersion.MINECRAFT_1_13)) {
                    channelIdentifiers.add(MinecraftChannelIdentifier.from(channel));
                    continue;
                }
                channelIdentifiers.add(new LegacyChannelIdentifier(channel));
            }
        }
        catch (IllegalArgumentException e) {
            if (MinecraftDecoder.DEBUG) {
                throw e;
            }
            throw ILLEGAL_CHANNEL;
        }
        return channelIdentifiers.build();
    }

    public static PluginMessagePacket constructChannelsPacket(ProtocolVersion protocolVersion, Collection<ChannelIdentifier> channels) {
        Preconditions.checkNotNull(channels, "channels");
        Preconditions.checkArgument(!channels.isEmpty(), "no channels specified");
        String channelName = protocolVersion.noLessThan(ProtocolVersion.MINECRAFT_1_13) ? REGISTER_CHANNEL : REGISTER_CHANNEL_LEGACY;
        ByteBuf contents = Unpooled.buffer();
        contents.writeCharSequence(PluginMessageUtil.joinChannels(channels), StandardCharsets.UTF_8);
        return new PluginMessagePacket(channelName, contents);
    }

    private static String joinChannels(Collection<ChannelIdentifier> channels) {
        Preconditions.checkNotNull(channels, "channels");
        Preconditions.checkArgument(!channels.isEmpty(), "no channels specified");
        StringBuilder sb = new StringBuilder();
        Iterator<ChannelIdentifier> iterator = channels.iterator();
        while (iterator.hasNext()) {
            ChannelIdentifier channel = iterator.next();
            sb.append(channel.getId());
            if (!iterator.hasNext()) continue;
            sb.append('\u0000');
        }
        return sb.toString();
    }

    public static PluginMessagePacket rewriteMinecraftBrand(PluginMessagePacket message, ProxyVersion version, ProtocolVersion protocolVersion) {
        Preconditions.checkNotNull(message, "message");
        Preconditions.checkNotNull(version, "version");
        Preconditions.checkArgument(PluginMessageUtil.isMcBrand(message), "message is not a brand plugin message");
        String currentBrand = PluginMessageUtil.readBrandMessage(message.content());
        String rewrittenBrand = String.format("%s (%s)", currentBrand, version.getName());
        ByteBuf rewrittenBuf = Unpooled.buffer();
        if (protocolVersion.noLessThan(ProtocolVersion.MINECRAFT_1_8)) {
            ProtocolUtils.writeString(rewrittenBuf, rewrittenBrand);
        } else {
            rewrittenBuf.writeCharSequence(rewrittenBrand, StandardCharsets.UTF_8);
        }
        return new PluginMessagePacket(message.getChannel(), rewrittenBuf);
    }

    public static String readBrandMessage(ByteBuf content) {
        try {
            return ProtocolUtils.readString(content.slice());
        }
        catch (Exception e) {
            return ProtocolUtils.readStringWithoutLength(content.slice());
        }
    }

    public static String transformLegacyToModernChannel(String name) {
        Preconditions.checkNotNull(name, "name");
        if (name.indexOf(58) != -1) {
            return name;
        }
        switch (name) {
            case "REGISTER": {
                return REGISTER_CHANNEL;
            }
            case "UNREGISTER": {
                return UNREGISTER_CHANNEL;
            }
            case "MC|Brand": {
                return BRAND_CHANNEL;
            }
            case "BungeeCord": {
                return "bungeecord:main";
            }
        }
        String lower = name.toLowerCase(Locale.ROOT);
        return "legacy:" + INVALID_IDENTIFIER_REGEX.matcher(lower).replaceAll("");
    }
}

