/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.server;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import com.velocitypowered.api.proxy.messages.PluginMessageEncoder;
import com.velocitypowered.api.proxy.server.PingOptions;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import com.velocitypowered.api.proxy.server.ServerInfo;
import com.velocitypowered.api.proxy.server.ServerPing;
import com.velocitypowered.proxy.VelocityServer;
import com.velocitypowered.proxy.connection.MinecraftConnection;
import com.velocitypowered.proxy.connection.backend.VelocityServerConnection;
import com.velocitypowered.proxy.connection.client.ConnectedPlayer;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import com.velocitypowered.proxy.protocol.StateRegistry;
import com.velocitypowered.proxy.protocol.netty.MinecraftDecoder;
import com.velocitypowered.proxy.protocol.netty.MinecraftEncoder;
import com.velocitypowered.proxy.protocol.netty.MinecraftVarintFrameDecoder;
import com.velocitypowered.proxy.protocol.netty.MinecraftVarintLengthEncoder;
import com.velocitypowered.proxy.protocol.util.ByteBufDataOutput;
import com.velocitypowered.proxy.server.PingSessionHandler;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoop;
import io.netty.handler.timeout.ReadTimeoutHandler;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.audience.ForwardingAudience;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.NotNull;

public class VelocityRegisteredServer
implements RegisteredServer,
ForwardingAudience {
    private final @Nullable VelocityServer server;
    private final ServerInfo serverInfo;
    private final Map<UUID, ConnectedPlayer> players = new ConcurrentHashMap<UUID, ConnectedPlayer>();

    public VelocityRegisteredServer(@Nullable VelocityServer server, ServerInfo serverInfo) {
        this.server = server;
        this.serverInfo = Preconditions.checkNotNull(serverInfo, "serverInfo");
    }

    @Override
    public ServerInfo getServerInfo() {
        return this.serverInfo;
    }

    @Override
    public Collection<Player> getPlayersConnected() {
        return ImmutableList.copyOf(this.players.values());
    }

    @Override
    public CompletableFuture<ServerPing> ping(PingOptions pingOptions) {
        return this.ping(null, pingOptions);
    }

    @Override
    public CompletableFuture<ServerPing> ping() {
        return this.ping(null, PingOptions.DEFAULT);
    }

    public CompletableFuture<ServerPing> ping(@Nullable EventLoop loop, final PingOptions pingOptions) {
        if (this.server == null) {
            throw new IllegalStateException("No Velocity proxy instance available");
        }
        CompletableFuture<ServerPing> pingFuture = new CompletableFuture<ServerPing>();
        ((Bootstrap)this.server.createBootstrap(loop).handler(new ChannelInitializer<Channel>(){

            @Override
            protected void initChannel(Channel ch) {
                ch.pipeline().addLast("frame-decoder", (ChannelHandler)new MinecraftVarintFrameDecoder(ProtocolUtils.Direction.CLIENTBOUND)).addLast("read-timeout", (ChannelHandler)new ReadTimeoutHandler(pingOptions.getTimeout() == 0L ? (long)VelocityRegisteredServer.this.server.getConfiguration().getReadTimeout() : pingOptions.getTimeout(), TimeUnit.MILLISECONDS)).addLast("frame-encoder", (ChannelHandler)MinecraftVarintLengthEncoder.INSTANCE).addLast("minecraft-decoder", (ChannelHandler)new MinecraftDecoder(ProtocolUtils.Direction.CLIENTBOUND)).addLast("minecraft-encoder", (ChannelHandler)new MinecraftEncoder(ProtocolUtils.Direction.SERVERBOUND));
                ch.pipeline().addLast("handler", (ChannelHandler)new MinecraftConnection(ch, VelocityRegisteredServer.this.server));
            }
        })).connect(this.serverInfo.getAddress()).addListener(future -> {
            if (future.isSuccess()) {
                MinecraftConnection conn = future.channel().pipeline().get(MinecraftConnection.class);
                PingSessionHandler handler = new PingSessionHandler(pingFuture, this, conn, pingOptions.getProtocolVersion(), pingOptions.getVirtualHost());
                conn.setActiveSessionHandler(StateRegistry.HANDSHAKE, handler);
            } else {
                pingFuture.completeExceptionally(future.cause());
            }
        });
        return pingFuture;
    }

    public void addPlayer(ConnectedPlayer player) {
        this.players.put(player.getUniqueId(), player);
    }

    public void removePlayer(ConnectedPlayer player) {
        this.players.remove(player.getUniqueId(), player);
    }

    @Override
    public boolean sendPluginMessage(@NotNull ChannelIdentifier identifier, byte @NotNull [] data) {
        Objects.requireNonNull(identifier);
        Objects.requireNonNull(data);
        return this.sendPluginMessage(identifier, Unpooled.wrappedBuffer(data));
    }

    @Override
    public boolean sendPluginMessage(@NotNull ChannelIdentifier identifier, @NotNull PluginMessageEncoder dataEncoder) {
        Objects.requireNonNull(identifier);
        Objects.requireNonNull(dataEncoder);
        ByteBuf buf = Unpooled.buffer();
        ByteBufDataOutput dataInput = new ByteBufDataOutput(buf);
        dataEncoder.encode(dataInput);
        if (buf.isReadable()) {
            return this.sendPluginMessage(identifier, buf);
        }
        buf.release();
        return false;
    }

    public boolean sendPluginMessage(ChannelIdentifier identifier, ByteBuf data) {
        for (ConnectedPlayer player : this.players.values()) {
            VelocityServerConnection serverConnection = player.getConnectedServer();
            if (serverConnection == null || serverConnection.getConnection() == null || serverConnection.getServer() != this) continue;
            return serverConnection.sendPluginMessage(identifier, data);
        }
        data.release();
        return false;
    }

    public String toString() {
        return "registered server: " + this.serverInfo;
    }

    @Override
    public @NonNull Iterable<? extends Audience> audiences() {
        return this.getPlayersConnected();
    }
}

