/*
 * Decompiled with CFR 0.152.
 */
package foxlaunch;

import foxlaunch.LanguageUtils;
import foxlaunch.LibrariesDownloader;
import foxlaunch.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class DataManager {
    private static final Map<String, File> librariesMap = new TreeMap<String, File>();
    private static final Map<String, File> librariesWithoutLaunchMap = new TreeMap<String, File>();
    private static final Map<String, String> librariesHashMap = new TreeMap<String, String>();
    private static final Map<String, File> foxLaunchLibsMap = new TreeMap<String, File>();
    private static final Map<String, String> versionData = new TreeMap<String, String>();

    public static void setup() {
        File foxLaunchData;
        File foxLaunchLibs = new File("foxlaunch-libs");
        if (!foxLaunchLibs.exists()) {
            foxLaunchLibs.mkdirs();
        }
        if (!(foxLaunchData = new File("foxlaunch-data")).exists()) {
            foxLaunchData.mkdirs();
        }
        try (JarFile serverJar = new JarFile(Utils.findServerJar());){
            String[] libraries;
            String classPath = Objects.requireNonNull(serverJar.getManifest().getMainAttributes().getValue("Installer-Class-Path"), "Missing MANIFEST.MF?");
            for (String library : libraries = classPath.split(" ")) {
                File file = new File(library);
                librariesWithoutLaunchMap.put(file.getName(), file.getParentFile());
            }
            if (librariesWithoutLaunchMap.size() == 0) {
                throw new RuntimeException("Installer Class-Path is empty!");
            }
            librariesWithoutLaunchMap.put("minecraft_server.1.18.2.jar", new File("foxlaunch-data/"));
            librariesWithoutLaunchMap.put("commons-lang-2.6.jar", new File("libraries/commons-lang/commons-lang/2.6/"));
            librariesWithoutLaunchMap.put("commons-codec-1.10.jar", new File("libraries/commons-codec/commons-codec/1.10/"));
            librariesMap.put("bootstraplauncher-1.0.0.jar", new File("libraries/cpw/mods/bootstraplauncher/1.0.0/"));
            librariesMap.put("JarJarFileSystems-0.3.19.jar", new File("libraries/net/minecraftforge/JarJarFileSystems/0.3.19/"));
            versionData.put("minecraft", Objects.requireNonNull(serverJar.getManifest().getAttributes("net/minecraftforge/versions/mcp/").getValue(Attributes.Name.SPECIFICATION_VERSION)));
            versionData.put("mcp", Objects.requireNonNull(serverJar.getManifest().getAttributes("net/minecraftforge/versions/mcp/").getValue(Attributes.Name.IMPLEMENTATION_VERSION)));
            versionData.put("forge", Objects.requireNonNull(serverJar.getManifest().getAttributes("net/minecraftforge/versions/forge/").getValue(Attributes.Name.IMPLEMENTATION_VERSION)));
            Enumeration<JarEntry> entry = serverJar.entries();
            while (entry.hasMoreElements()) {
                String[] split;
                BufferedReader reader;
                String[] name;
                JarEntry jarEntry = entry.nextElement();
                if (jarEntry == null || (name = jarEntry.getName().split("/")).length != 2 || !Objects.equals(name[0], "data")) continue;
                if (name[1].endsWith(".jar")) {
                    File path = librariesMap.get(name[1]);
                    if (path == null) {
                        String[] split2 = name[1].substring(0, name[1].length() - 4).split("-");
                        if (split2.length == 3) {
                            if (Objects.equals(split2[0], "fmlcore") || Objects.equals(split2[0], "fmlloader") || Objects.equals(split2[0], "javafmllanguage") || Objects.equals(split2[0], "mclanguage") || Objects.equals(split2[0], "lowcodelanguage")) {
                                path = new File("libraries/net/minecraftforge/" + split2[0] + "/" + split2[1] + "-" + split2[2]);
                            }
                        } else if (split2.length == 4 && Objects.equals(split2[0], "forge") && Objects.equals(split2[3], "universal")) {
                            path = new File("libraries/net/minecraftforge/" + split2[0] + "/" + split2[1] + "-" + split2[2]);
                        }
                    }
                    boolean isCustomLib = false;
                    if (path == null) {
                        path = foxLaunchLibs;
                        foxLaunchLibsMap.put(name[1], path);
                        isCustomLib = true;
                    } else if (!path.exists()) {
                        path.mkdirs();
                    }
                    File file = new File(path, name[1]);
                    if (isCustomLib && file.exists() && !Utils.isJarCorrupted(file)) continue;
                    FileOutputStream out = new FileOutputStream(file);
                    try {
                        try (InputStream in = serverJar.getInputStream(jarEntry);){
                            int readSize;
                            byte[] bytes = new byte[4096];
                            while ((readSize = in.read(bytes)) > 0) {
                                ((OutputStream)out).write(bytes, 0, readSize);
                            }
                        }
                        out.flush();
                        continue;
                    }
                    finally {
                        ((OutputStream)out).close();
                        continue;
                    }
                }
                if (Objects.equals(name[1], "server.lzma")) {
                    FileOutputStream out = new FileOutputStream(new File(foxLaunchData, name[1]));
                    try {
                        try (InputStream in = serverJar.getInputStream(jarEntry);){
                            int readSize;
                            byte[] bytes = new byte[4096];
                            while ((readSize = in.read(bytes)) > 0) {
                                ((OutputStream)out).write(bytes, 0, readSize);
                            }
                        }
                        out.flush();
                        continue;
                    }
                    finally {
                        ((OutputStream)out).close();
                        continue;
                    }
                }
                if (Objects.equals(name[1], "libraries-launch.txt")) {
                    reader = new BufferedReader(new InputStreamReader(serverJar.getInputStream(jarEntry)));
                    try {
                        String line = reader.readLine();
                        if (!line.startsWith("libraries/")) continue;
                        for (String library : split = line.split(";")) {
                            File file = new File(library);
                            librariesMap.put(file.getName(), file.getParentFile());
                        }
                        continue;
                    }
                    finally {
                        reader.close();
                        continue;
                    }
                }
                if (!Objects.equals(name[1], "libraries-all.txt")) continue;
                reader = new BufferedReader(new InputStreamReader(serverJar.getInputStream(jarEntry)));
                try {
                    String line = reader.readLine();
                    if (!Objects.equals(line, "===ALGORITHM SHA-256")) continue;
                    while ((line = reader.readLine()) != null) {
                        String[] split2;
                        split = line.split(" ");
                        if (split.length != 2 || (split2 = split[0].split(":")).length != 3) continue;
                        librariesHashMap.put(split2[1] + "-" + split2[2] + ".jar", split[1]);
                    }
                }
                finally {
                    reader.close();
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not unpack data!", e);
        }
    }

    public static void downloadLibraries() {
        TreeMap<File, String> needDownloadLibrariesMap = new TreeMap<File, String>();
        TreeMap<File, String> needDownloadMappingDataMap = new TreeMap<File, String>();
        for (Map librariesMap : new Map[]{DataManager.librariesMap, librariesWithoutLaunchMap}) {
            for (Map.Entry libraryEntry : librariesMap.entrySet()) {
                String filename = (String)libraryEntry.getKey();
                String sha256 = librariesHashMap.get(filename);
                sha256 = sha256 == null ? Utils.getMissingSHA256(filename) : sha256.toUpperCase();
                File file = new File((File)libraryEntry.getValue(), (String)libraryEntry.getKey());
                if (file.exists() && (sha256 == null || Objects.equals(Utils.getFileSHA256(file), sha256))) continue;
                needDownloadLibrariesMap.put(file, sha256);
            }
        }
        String minecraftVersion = versionData.get("minecraft");
        String mcpVersion = versionData.get("mcp");
        if (minecraftVersion != null && mcpVersion != null) {
            File minecraftMappings;
            File mcpZip = new File(String.format("libraries/de/oceanlabs/mcp/mcp_config/%s-%s/mcp_config-%s-%s.zip", minecraftVersion, mcpVersion, minecraftVersion, mcpVersion));
            if (!mcpZip.exists() || !Objects.equals(Utils.getFileSHA256(mcpZip), Utils.getMissingSHA256(mcpZip.getName()))) {
                needDownloadMappingDataMap.put(mcpZip, Utils.getMissingSHA256(mcpZip.getName()));
            }
            if (!(minecraftMappings = new File(String.format("foxlaunch-data/server-%s-mappings.txt", minecraftVersion))).exists() || !Objects.equals(Utils.getFileSHA256(minecraftMappings), Utils.getMissingSHA256(minecraftMappings.getName()))) {
                needDownloadMappingDataMap.put(new File(String.format("foxlaunch-data/server-%s-mappings.packed", minecraftVersion)), Utils.getMissingSHA256(minecraftMappings.getName()));
            }
        }
        if (needDownloadLibrariesMap.size() > 0 || needDownloadMappingDataMap.size() > 0) {
            System.out.println(LanguageUtils.I18nToString("launch.lib_missing"));
            LibrariesDownloader.setupDownloadSource();
            for (Map.Entry libraryEntry : needDownloadLibrariesMap.entrySet()) {
                if (Objects.equals(((File)libraryEntry.getKey()).getName(), "server-" + versionData.get("minecraft") + "-" + versionData.get("mcp") + "-extra.jar")) continue;
                LibrariesDownloader.tryDownload((File)libraryEntry.getKey(), (String)libraryEntry.getValue());
            }
            for (Map.Entry libraryEntry : needDownloadMappingDataMap.entrySet()) {
                LibrariesDownloader.tryDownload((File)libraryEntry.getKey(), (String)libraryEntry.getValue(), "mappings-data");
            }
            System.out.println(LanguageUtils.I18nToString("launch.lib_download_completed"));
        }
    }

    public static Map<String, File> getLibrariesMap() {
        return librariesMap;
    }

    public static String getVersionData(String target) {
        return versionData.get(target);
    }

    protected static void gc() {
        librariesMap.clear();
        librariesWithoutLaunchMap.clear();
        librariesHashMap.clear();
        foxLaunchLibsMap.clear();
        versionData.clear();
        System.gc();
    }
}

