/*
 * Decompiled with CFR 0.152.
 */
package foxlaunch;

import foxlaunch.LanguageUtils;
import foxlaunch.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class LibrariesDownloader {
    private static final List<String> librariesSources = new ArrayList<String>();

    public static void setupDownloadSource() {
        try {
            String str = LibrariesDownloader.sendRequest("https://catserver.moe/api/libraries_sources/");
            for (String s : str.split("\\|")) {
                if (!s.startsWith("http://") && !s.startsWith("https://") && !s.startsWith("httpauth://")) continue;
                librariesSources.add(s);
            }
        }
        catch (IOException e) {
            System.out.println(e.toString());
        }
        if (librariesSources.size() == 0) {
            librariesSources.add("http://sv.catserver.moe:8001/dl/");
            librariesSources.add("http://sv2.catserver.moe:8001/dl/");
            librariesSources.add("http://cdn.catserver.moe/dl/");
        }
    }

    public static void tryDownload(File file, String sha256) {
        LibrariesDownloader.tryDownload(file, sha256, null);
    }

    public static void tryDownload(File file, String sha256, String dir) {
        Iterator<String> iterator = librariesSources.iterator();
        while (iterator.hasNext()) {
            String downloadUrl = iterator.next() + (dir == null ? "" : dir + "/") + file.getName();
            try {
                String authKey = null;
                if (downloadUrl.startsWith("httpauth://")) {
                    String[] split = downloadUrl.substring("httpauth://".length()).split("###auth###/");
                    authKey = split[0];
                    downloadUrl = split[1];
                }
                if (sha256 == null && downloadUrl.startsWith("http://")) {
                    System.out.println(String.format("[Warning] Trying to download a file (%s) that missing SHA256 from http protocol, possible security risk!", file.getName()));
                }
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                new Downloader(downloadUrl, file, authKey);
                if (file.exists() && file.getName().endsWith(".packed")) {
                    file = Utils.unpackSingleFileZip(file);
                }
                if (!file.exists() || sha256 != null && !Objects.equals(Utils.getFileSHA256(file), sha256)) {
                    System.out.println(String.format(LanguageUtils.I18nToString("launch.lib_failure_check"), file.getName(), downloadUrl));
                }
                return;
            }
            catch (IOException e) {
                if (e instanceof ConnectException || e instanceof SocketTimeoutException || e instanceof UnknownHostException) {
                    System.out.println(String.format(LanguageUtils.I18nToString("launch.lib_failure_download_source_error"), downloadUrl, e.toString()));
                    iterator.remove();
                    continue;
                }
                System.out.println(String.format(LanguageUtils.I18nToString("launch.lib_failure_download"), e.toString(), downloadUrl));
            }
        }
    }

    private static String sendRequest(String url) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
        connection.setRequestProperty("Accept", "*/*");
        connection.setRequestProperty("Connection", "Close");
        connection.connect();
        String result = "";
        try (BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));){
            String line;
            while ((line = in.readLine()) != null) {
                result = result + line;
            }
        }
        return result;
    }

    static class Downloader {
        public Downloader(String downloadUrl, File saveFile) throws IOException {
            this(downloadUrl, saveFile, null);
        }

        public Downloader(String downloadUrl, File saveFile, String authKey) throws IOException {
            URL url = new URL(downloadUrl);
            final HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(8000);
            connection.setRequestMethod("GET");
            if (authKey != null) {
                connection.setRequestProperty("authorization", "Basic " + authKey);
            }
            System.out.println(String.format(LanguageUtils.I18nToString("launch.lib_downloading"), saveFile.getName(), this.getSize(connection.getContentLengthLong())));
            ReadableByteChannel rbc = new ReadableByteChannel(){
                final ReadableByteChannel rbc0;
                long currentTime;
                int totalRead;
                int bytesRead;
                int lastTotalRead;
                {
                    this.rbc0 = Channels.newChannel(connection.getInputStream());
                    this.currentTime = System.currentTimeMillis();
                    this.totalRead = 0;
                    this.bytesRead = 0;
                    this.lastTotalRead = 0;
                }

                @Override
                public boolean isOpen() {
                    return this.rbc0.isOpen();
                }

                @Override
                public void close() throws IOException {
                    this.rbc0.close();
                }

                @Override
                public int read(ByteBuffer dst) throws IOException {
                    this.bytesRead = this.rbc0.read(dst);
                    this.totalRead += this.bytesRead;
                    if (System.currentTimeMillis() - this.currentTime > 1000L) {
                        System.out.println("> " + this.getSize(this.totalRead) + "  (" + this.getSize(this.totalRead - this.lastTotalRead) + "/S)");
                        this.currentTime = System.currentTimeMillis();
                        this.lastTotalRead = this.totalRead;
                    }
                    return this.bytesRead;
                }
            };
            FileOutputStream fos = new FileOutputStream(saveFile);
            fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
            rbc.close();
            fos.close();
            connection.disconnect();
        }

        private String getSize(long size) {
            if (size >= 0x100000L) {
                return (float)size / 1048576.0f + " MB";
            }
            if (size >= 1024L) {
                return (float)size / 1024.0f + " KB";
            }
            return size + " B";
        }
    }
}

