/*
 * Decompiled with CFR 0.152.
 */
package foxlaunch.legacy;

import foxlaunch.Utils;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.net.URL;
import java.util.Objects;

public class InstallTool {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean install(String minecraftVersion, String mcpVersion, String forgeVersion) throws Exception {
        File forgeServerJar;
        File minecraftSrg;
        File minecraftSlim;
        File minecraftExtra;
        File mergedMappings;
        File minecraftMappings;
        File minecraftUnpack;
        File minecraftServer;
        File mcpMappings;
        File mcpZip;
        File serverLZMA;
        File serverJar;
        File installLog;
        File installHASH;
        URL[] libBinaryPatcher;
        URL[] libForgeAutoRenamingTool;
        URL[] libJarSplitter;
        URL[] libInstallerTools;
        block24: {
            if (minecraftVersion == null || mcpVersion == null || forgeVersion == null) {
                throw new RuntimeException(String.format("Missing version data: [minecraft: %s, mcp: %s, forge: %s]", minecraftVersion, mcpVersion, forgeVersion));
            }
            libInstallerTools = new URL[]{Utils.pathToURL("foxlaunch-libs/installertools-1.2.10.jar"), Utils.pathToURL("foxlaunch-libs/fastcsv-2.0.0.jar"), Utils.pathToURL("foxlaunch-libs/srgutils-0.4.11.jar"), Utils.pathToURL("libraries/com/google/code/gson/gson/2.8.9/gson-2.8.9.jar"), Utils.pathToURL("libraries/net/md-5/SpecialSource/1.10.0/SpecialSource-1.10.0.jar"), Utils.pathToURL("libraries/net/sf/jopt-simple/jopt-simple/5.0.4/jopt-simple-5.0.4.jar"), Utils.pathToURL("libraries/com/google/guava/guava/31.0.1-jre/guava-31.0.1-jre.jar"), Utils.pathToURL("libraries/org/ow2/asm/asm-commons/9.5/asm-commons-9.5.jar"), Utils.pathToURL("libraries/org/ow2/asm/asm-analysis/9.5/asm-analysis-9.5.jar"), Utils.pathToURL("libraries/org/ow2/asm/asm-tree/9.5/asm-tree-9.5.jar"), Utils.pathToURL("libraries/org/ow2/asm/asm/9.5/asm-9.5.jar")};
            libJarSplitter = new URL[]{Utils.pathToURL("foxlaunch-libs/jarsplitter-1.1.4.jar"), Utils.pathToURL("foxlaunch-libs/srgutils-0.4.11.jar"), Utils.pathToURL("libraries/net/sf/jopt-simple/jopt-simple/5.0.4/jopt-simple-5.0.4.jar")};
            libForgeAutoRenamingTool = new URL[]{Utils.pathToURL("foxlaunch-libs/ForgeAutoRenamingTool-0.1.22.jar"), Utils.pathToURL("foxlaunch-libs/srgutils-0.4.11.jar"), Utils.pathToURL("libraries/net/sf/jopt-simple/jopt-simple/5.0.4/jopt-simple-5.0.4.jar"), Utils.pathToURL("libraries/org/ow2/asm/asm-commons/9.5/asm-commons-9.5.jar"), Utils.pathToURL("libraries/org/ow2/asm/asm-analysis/9.5/asm-analysis-9.5.jar"), Utils.pathToURL("libraries/org/ow2/asm/asm-tree/9.5/asm-tree-9.5.jar"), Utils.pathToURL("libraries/org/ow2/asm/asm/9.5/asm-9.5.jar")};
            libBinaryPatcher = new URL[]{Utils.pathToURL("foxlaunch-libs/binarypatcher-1.0.12.jar"), Utils.pathToURL("libraries/commons-io/commons-io/2.11.0/commons-io-2.11.0.jar"), Utils.pathToURL("libraries/com/google/guava/guava/31.0.1-jre/guava-31.0.1-jre.jar"), Utils.pathToURL("libraries/net/sf/jopt-simple/jopt-simple/5.0.4/jopt-simple-5.0.4.jar"), Utils.pathToURL("libraries/commons-io/commons-io/2.11.0/commons-io-2.11.0.jar")};
            installHASH = new File("foxlaunch-data/install.dat");
            installLog = new File("foxlaunch-data/install.log");
            serverJar = Utils.findServerJar();
            serverLZMA = new File("foxlaunch-data/server.lzma");
            mcpZip = new File(String.format("libraries/de/oceanlabs/mcp/mcp_config/%s-%s/mcp_config-%s-%s.zip", minecraftVersion, mcpVersion, minecraftVersion, mcpVersion));
            mcpMappings = new File(String.format("libraries/de/oceanlabs/mcp/mcp_config/%s-%s/mcp_config-%s-%s-mappings.txt", minecraftVersion, mcpVersion, minecraftVersion, mcpVersion));
            minecraftServer = new File("foxlaunch-data/minecraft_server." + minecraftVersion + ".jar");
            minecraftUnpack = new File(String.format("foxlaunch-data/server-%s.jar", minecraftVersion));
            minecraftMappings = new File(String.format("foxlaunch-data/server-%s-mappings.txt", minecraftVersion));
            mergedMappings = new File(String.format("libraries/net/minecraft/server/%s-%s/server-%s-%s-mappings-merged.txt", minecraftVersion, mcpVersion, minecraftVersion, mcpVersion));
            minecraftExtra = new File(String.format("libraries/net/minecraft/server/%s-%s/server-%s-%s-extra.jar", minecraftVersion, mcpVersion, minecraftVersion, mcpVersion));
            minecraftSlim = new File(String.format("libraries/net/minecraft/server/%s-%s/server-%s-%s-slim.jar", minecraftVersion, mcpVersion, minecraftVersion, mcpVersion));
            minecraftSrg = new File(String.format("libraries/net/minecraft/server/%s-%s/server-%s-%s-srg.jar", minecraftVersion, mcpVersion, minecraftVersion, mcpVersion));
            File forgeUniversalJar = new File(String.format("libraries/net/minecraftforge/forge/%s-%s/forge-%s-%s-universal.jar", minecraftVersion, forgeVersion, minecraftVersion, forgeVersion));
            forgeServerJar = new File(String.format("libraries/net/minecraftforge/forge/%s-%s/forge-%s-%s-server.jar", minecraftVersion, forgeVersion, minecraftVersion, forgeVersion));
            for (File checkFile : new File[]{minecraftServer, mcpZip, serverLZMA, forgeUniversalJar}) {
                if (checkFile.exists()) continue;
                throw new RuntimeException("Missing " + checkFile.getAbsolutePath() + " File!");
            }
            try {
                if (!installHASH.exists()) break block24;
                try (BufferedReader reader222 = new BufferedReader(new InputStreamReader(new FileInputStream(installHASH)));){
                    if (Objects.equals(reader222.readLine(), Objects.requireNonNull(Utils.getFileSHA256(serverJar), serverJar.getName()) + Objects.requireNonNull(Utils.getFileSHA256(serverLZMA), serverLZMA.getName()))) {
                        int n = 0;
                        return n != 0;
                    }
                }
            }
            catch (Exception reader222) {
                // empty catch block
            }
        }
        PrintStream originOutPrint = System.out;
        PrintStream logOutPrint = new PrintStream(new BufferedOutputStream(new FileOutputStream(installLog)));
        System.setOut(logOutPrint);
        originOutPrint.println("[FoxLaunch] Unpacking vanilla server jar..");
        if (Utils.isJarCorrupted(minecraftUnpack)) {
            minecraftUnpack.delete();
        }
        if (!minecraftUnpack.exists()) {
            Utils.unpackZipEntry(minecraftServer, minecraftUnpack, "META-INF/versions/" + minecraftVersion + "/server-" + minecraftVersion + ".jar");
        }
        originOutPrint.println("[FoxLaunch] Initializing MCP data..");
        if (!mcpMappings.exists()) {
            Utils.relaunch("net.minecraftforge.installertools.ConsoleTool", libInstallerTools, new String[]{"--task", "MCP_DATA", "--input", mcpZip.getAbsolutePath(), "--output", mcpMappings.getAbsolutePath(), "--key", "mappings"}, true);
        }
        originOutPrint.println("[FoxLaunch] Downloading vanilla mappings..");
        if (!minecraftMappings.exists()) {
            Utils.relaunch("net.minecraftforge.installertools.ConsoleTool", libInstallerTools, new String[]{"--task", "DOWNLOAD_MOJMAPS", "--version", minecraftVersion, "--side", "server", "--output", minecraftMappings.getAbsolutePath()}, true);
        }
        originOutPrint.println("[FoxLaunch] Merging mappings..");
        if (!mergedMappings.exists()) {
            Utils.relaunch("net.minecraftforge.installertools.ConsoleTool", libInstallerTools, new String[]{"--task", "MERGE_MAPPING", "--left", mcpMappings.getAbsolutePath(), "--right", minecraftMappings.getAbsolutePath(), "--output", mergedMappings.getAbsolutePath(), "--classes", "--reverse-right"}, true);
        }
        originOutPrint.println("[FoxLaunch] Splitting server jar..");
        if (Utils.isJarCorrupted(minecraftSlim) || Utils.isJarCorrupted(minecraftExtra)) {
            minecraftSlim.delete();
            minecraftExtra.delete();
        }
        if (!minecraftSlim.exists() || !minecraftExtra.exists()) {
            Utils.relaunch("net.minecraftforge.jarsplitter.ConsoleTool", libJarSplitter, new String[]{"--input", minecraftUnpack.getAbsolutePath(), "--slim", minecraftSlim.getAbsolutePath(), "--extra", minecraftExtra.getAbsolutePath(), "--srg", mergedMappings.getAbsolutePath()}, true);
        }
        originOutPrint.println("[FoxLaunch] Remapping server jar..");
        if (Utils.isJarCorrupted(minecraftSrg)) {
            minecraftSrg.delete();
        }
        if (!minecraftSrg.exists()) {
            Utils.relaunch("net.minecraftforge.fart.Main", libForgeAutoRenamingTool, new String[]{"--input", minecraftSlim.getAbsolutePath(), "--output", minecraftSrg.getAbsolutePath(), "--names", mergedMappings.getAbsolutePath(), "--ann-fix", "--ids-fix", "--src-fix", "--record-fix"}, true);
        }
        originOutPrint.println("[FoxLaunch] Applying patches..");
        Utils.relaunch("net.minecraftforge.binarypatcher.ConsoleTool", libBinaryPatcher, new String[]{"--clean", minecraftSrg.getAbsolutePath(), "--output", forgeServerJar.getAbsolutePath(), "--apply", serverLZMA.getAbsolutePath()}, true);
        logOutPrint.flush();
        logOutPrint.close();
        System.setOut(originOutPrint);
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(installHASH)));){
            writer.write(Objects.requireNonNull(Utils.getFileSHA256(serverJar), serverJar.getName()) + Objects.requireNonNull(Utils.getFileSHA256(serverLZMA), serverLZMA.getName()));
            return true;
        }
    }
}

