/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paperclip;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

class Utils {
    Utils() {
    }

    static byte[] fromHex(String s) {
        if (s.length() % 2 != 0) {
            throw new IllegalArgumentException("Hex " + s + " must be divisible by two");
        }
        byte[] bytes = new byte[s.length() / 2];
        for (int i = 0; i < bytes.length; ++i) {
            byte b;
            char left = s.charAt(i * 2);
            char right = s.charAt(i * 2 + 1);
            bytes[i] = b = (byte)(Utils.getValue(left) << 4 | Utils.getValue(right) & 0xF);
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] readFully(InputStream in) throws IOException {
        try {
            int read;
            byte[] buffer = new byte[16384];
            int off = 0;
            while ((read = in.read(buffer, off, buffer.length - off)) != -1) {
                if ((off += read) != buffer.length) continue;
                buffer = Arrays.copyOf(buffer, buffer.length * 2);
            }
            byte[] byArray = Arrays.copyOfRange(buffer, 0, off);
            return byArray;
        }
        finally {
            in.close();
        }
    }

    private static int getValue(char c) {
        int i = Character.digit(c, 16);
        if (i < 0) {
            throw new IllegalArgumentException("Invalid hex char: " + c);
        }
        return i;
    }
}

