/*
 * Decompiled with CFR 0.152.
 */
package io.github.waterfallmc.waterfall.log4j;

import com.google.common.base.Strings;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.jul.LevelTranslator;
import org.apache.logging.log4j.message.MessageFormatMessage;

class Log4JLogHandler
extends Handler {
    private final Map<String, Logger> cache = new ConcurrentHashMap<String, Logger>();

    Log4JLogHandler() {
    }

    @Override
    public void publish(LogRecord record) {
        Logger logger = this.cache.computeIfAbsent(Strings.nullToEmpty(record.getLoggerName()), LogManager::getLogger);
        String message = record.getMessage();
        if (record.getResourceBundle() != null) {
            try {
                message = record.getResourceBundle().getString(message);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        Level level = LevelTranslator.toLevel(record.getLevel());
        if (record.getParameters() != null && record.getParameters().length > 0) {
            logger.log(level, new MessageFormatMessage(message, record.getParameters()), record.getThrown());
        } else {
            logger.log(level, message, record.getThrown());
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }
}

