/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee;

import io.github.waterfallmc.waterfall.console.WaterfallConsole;
import java.security.Security;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.api.ProxyServer;

public class BungeeCordLauncher {
    public static void main(String[] args) throws Exception {
        Security.setProperty("networkaddress.cache.ttl", "30");
        Security.setProperty("networkaddress.cache.negative.ttl", "10");
        OptionParser parser = new OptionParser();
        parser.allowsUnrecognizedOptions();
        parser.acceptsAll(Arrays.asList("help"), "Show the help");
        parser.acceptsAll(Arrays.asList("v", "version"), "Print version and exit");
        parser.acceptsAll(Arrays.asList("noconsole"), "Disable console input");
        OptionSet options = parser.parse(args);
        if (options.has("help")) {
            parser.printHelpOn(System.out);
            return;
        }
        if (options.has("version")) {
            System.out.println(BungeeCord.class.getPackage().getImplementationVersion());
            return;
        }
        if (BungeeCord.class.getPackage().getSpecificationVersion() != null && System.getProperty("IReallyKnowWhatIAmDoingISwear") == null) {
            Date buildDate = new SimpleDateFormat("yyyyMMdd").parse(BungeeCord.class.getPackage().getSpecificationVersion());
            Calendar deadline = Calendar.getInstance();
            deadline.add(3, -4);
            if (buildDate.before(deadline.getTime())) {
                System.err.println("*** Hey! This build is potentially outdated :( ***");
                System.err.println("*** Please check for a new build from https://papermc.io/ci/job/Waterfall/ ***");
                System.err.println("*** Should this build be outdated, you will get NO support for it. ***");
                System.err.println("*** Server will start in 10 seconds ***");
                Thread.sleep(TimeUnit.SECONDS.toMillis(10L));
            }
        }
        BungeeCord bungee = new BungeeCord();
        ProxyServer.setInstance(bungee);
        bungee.getLogger().info("Enabled Waterfall version " + bungee.getVersion());
        bungee.start();
        if (!options.has("noconsole")) {
            new WaterfallConsole().start();
        }
    }
}

