/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.jul;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Filter;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.jul.LevelTranslator;
import org.apache.logging.log4j.jul.WrappedLogger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.spi.ExtendedLogger;

public class ApiLogger
extends Logger {
    private final WrappedLogger logger;
    private static final String FQCN = ApiLogger.class.getName();

    ApiLogger(ExtendedLogger logger) {
        super(logger.getName(), null);
        final java.util.logging.Level javaLevel = LevelTranslator.toJavaLevel(logger.getLevel());
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                ApiLogger.super.setLevel(javaLevel);
                return null;
            }
        });
        this.logger = new WrappedLogger(logger);
    }

    @Override
    public void log(LogRecord record) {
        if (this.isFiltered(record)) {
            return;
        }
        Level level = LevelTranslator.toLevel(record.getLevel());
        Object[] parameters = record.getParameters();
        Object messageFactory = this.logger.getMessageFactory();
        Message message = parameters == null ? messageFactory.newMessage(record.getMessage()) : messageFactory.newMessage(record.getMessage(), parameters);
        Throwable thrown = record.getThrown();
        this.logger.logIfEnabled(FQCN, level, null, message, thrown);
    }

    boolean isFiltered(LogRecord logRecord) {
        Filter filter = this.getFilter();
        return filter != null && !filter.isLoggable(logRecord);
    }

    @Override
    public boolean isLoggable(java.util.logging.Level level) {
        return this.logger.isEnabled(LevelTranslator.toLevel(level));
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    @Override
    public void setLevel(java.util.logging.Level newLevel) throws SecurityException {
        throw new UnsupportedOperationException("Cannot set level through log4j-api");
    }

    protected void doSetLevel(java.util.logging.Level newLevel) throws SecurityException {
        super.setLevel(newLevel);
    }

    @Override
    public void setParent(Logger parent) {
        throw new UnsupportedOperationException("Cannot set parent logger");
    }

    @Override
    public void log(java.util.logging.Level level, String msg) {
        if (this.getFilter() == null) {
            this.logger.log(LevelTranslator.toLevel(level), msg);
        } else {
            super.log(level, msg);
        }
    }

    @Override
    public void log(java.util.logging.Level level, String msg, Object param1) {
        if (this.getFilter() == null) {
            this.logger.log(LevelTranslator.toLevel(level), msg, param1);
        } else {
            super.log(level, msg, param1);
        }
    }

    @Override
    public void log(java.util.logging.Level level, String msg, Object[] params) {
        if (this.getFilter() == null) {
            this.logger.log(LevelTranslator.toLevel(level), msg, params);
        } else {
            super.log(level, msg, params);
        }
    }

    @Override
    public void log(java.util.logging.Level level, String msg, Throwable thrown) {
        if (this.getFilter() == null) {
            this.logger.log(LevelTranslator.toLevel(level), msg, thrown);
        } else {
            super.log(level, msg, thrown);
        }
    }

    @Override
    public void logp(java.util.logging.Level level, String sourceClass, String sourceMethod, String msg) {
        this.log(level, msg);
    }

    @Override
    public void logp(java.util.logging.Level level, String sourceClass, String sourceMethod, String msg, Object param1) {
        this.log(level, msg, param1);
    }

    @Override
    public void logp(java.util.logging.Level level, String sourceClass, String sourceMethod, String msg, Object[] params) {
        this.log(level, msg, params);
    }

    @Override
    public void logp(java.util.logging.Level level, String sourceClass, String sourceMethod, String msg, Throwable thrown) {
        this.log(level, msg, thrown);
    }

    @Override
    public void logrb(java.util.logging.Level level, String sourceClass, String sourceMethod, String bundleName, String msg) {
        this.log(level, msg);
    }

    @Override
    public void logrb(java.util.logging.Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Object param1) {
        this.log(level, msg, param1);
    }

    @Override
    public void logrb(java.util.logging.Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Object[] params) {
        this.log(level, msg, params);
    }

    @Override
    public void logrb(java.util.logging.Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Throwable thrown) {
        this.log(level, msg, thrown);
    }

    @Override
    public void entering(String sourceClass, String sourceMethod) {
        this.logger.entry();
    }

    @Override
    public void entering(String sourceClass, String sourceMethod, Object param1) {
        this.logger.entry(param1);
    }

    @Override
    public void entering(String sourceClass, String sourceMethod, Object[] params) {
        this.logger.entry(params);
    }

    @Override
    public void exiting(String sourceClass, String sourceMethod) {
        this.logger.exit();
    }

    @Override
    public void exiting(String sourceClass, String sourceMethod, Object result) {
        this.logger.exit(result);
    }

    @Override
    public void throwing(String sourceClass, String sourceMethod, Throwable thrown) {
        this.logger.throwing(thrown);
    }

    @Override
    public void severe(String msg) {
        if (this.getFilter() == null) {
            this.logger.logIfEnabled(FQCN, Level.ERROR, null, msg);
        } else {
            super.severe(msg);
        }
    }

    @Override
    public void warning(String msg) {
        if (this.getFilter() == null) {
            this.logger.logIfEnabled(FQCN, Level.WARN, null, msg);
        } else {
            super.warning(msg);
        }
    }

    @Override
    public void info(String msg) {
        if (this.getFilter() == null) {
            this.logger.logIfEnabled(FQCN, Level.INFO, null, msg);
        } else {
            super.info(msg);
        }
    }

    @Override
    public void config(String msg) {
        if (this.getFilter() == null) {
            this.logger.logIfEnabled(FQCN, LevelTranslator.CONFIG, null, msg);
        } else {
            super.config(msg);
        }
    }

    @Override
    public void fine(String msg) {
        if (this.getFilter() == null) {
            this.logger.logIfEnabled(FQCN, Level.DEBUG, null, msg);
        } else {
            super.fine(msg);
        }
    }

    @Override
    public void finer(String msg) {
        if (this.getFilter() == null) {
            this.logger.logIfEnabled(FQCN, Level.TRACE, null, msg);
        } else {
            super.finer(msg);
        }
    }

    @Override
    public void finest(String msg) {
        if (this.getFilter() == null) {
            this.logger.logIfEnabled(FQCN, LevelTranslator.FINEST, null, msg);
        } else {
            super.finest(msg);
        }
    }
}

