/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.scheduler;

import io.github.waterfallmc.waterfall.event.ProxyExceptionEvent;
import io.github.waterfallmc.waterfall.exception.ProxySchedulerException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import lombok.Generated;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.api.scheduler.ScheduledTask;
import net.md_5.bungee.scheduler.BungeeScheduler;

public class BungeeTask
implements Runnable,
ScheduledTask {
    private final BungeeScheduler sched;
    private final int id;
    private final Plugin owner;
    private final Runnable task;
    private final long delay;
    private final long period;
    private final AtomicBoolean running = new AtomicBoolean(true);

    public BungeeTask(BungeeScheduler sched, int id, Plugin owner, Runnable task, long delay, long period, TimeUnit unit) {
        this.sched = sched;
        this.id = id;
        this.owner = owner;
        this.task = task;
        this.delay = unit.toMillis(delay);
        this.period = unit.toMillis(period);
    }

    @Override
    public void cancel() {
        boolean wasRunning = this.running.getAndSet(false);
        if (wasRunning) {
            this.sched.cancel0(this);
        }
    }

    @Override
    public void run() {
        if (this.delay > 0L) {
            try {
                Thread.sleep(this.delay);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
        while (this.running.get()) {
            try {
                this.task.run();
            }
            catch (Throwable t2) {
                String msg = String.format("Task %s encountered an exception", this);
                ProxyServer.getInstance().getLogger().log(Level.SEVERE, msg, t2);
                ProxyServer.getInstance().getPluginManager().callEvent(new ProxyExceptionEvent(new ProxySchedulerException(msg, t2, this)));
            }
            if (this.period <= 0L) break;
            try {
                Thread.sleep(this.period);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
        this.cancel();
    }

    @Generated
    public BungeeScheduler getSched() {
        return this.sched;
    }

    @Override
    @Generated
    public int getId() {
        return this.id;
    }

    @Override
    @Generated
    public Plugin getOwner() {
        return this.owner;
    }

    @Override
    @Generated
    public Runnable getTask() {
        return this.task;
    }

    @Generated
    public long getDelay() {
        return this.delay;
    }

    @Generated
    public long getPeriod() {
        return this.period;
    }

    @Generated
    public AtomicBoolean getRunning() {
        return this.running;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BungeeTask)) {
            return false;
        }
        BungeeTask other = (BungeeTask)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (this.getDelay() != other.getDelay()) {
            return false;
        }
        if (this.getPeriod() != other.getPeriod()) {
            return false;
        }
        BungeeScheduler this$sched = this.getSched();
        BungeeScheduler other$sched = other.getSched();
        if (this$sched == null ? other$sched != null : !this$sched.equals(other$sched)) {
            return false;
        }
        Plugin this$owner = this.getOwner();
        Plugin other$owner = other.getOwner();
        if (this$owner == null ? other$owner != null : !this$owner.equals(other$owner)) {
            return false;
        }
        Runnable this$task = this.getTask();
        Runnable other$task = other.getTask();
        if (this$task == null ? other$task != null : !this$task.equals(other$task)) {
            return false;
        }
        AtomicBoolean this$running = this.getRunning();
        AtomicBoolean other$running = other.getRunning();
        return !(this$running == null ? other$running != null : !this$running.equals(other$running));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BungeeTask;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getId();
        long $delay = this.getDelay();
        result = result * 59 + (int)($delay >>> 32 ^ $delay);
        long $period = this.getPeriod();
        result = result * 59 + (int)($period >>> 32 ^ $period);
        BungeeScheduler $sched = this.getSched();
        result = result * 59 + ($sched == null ? 43 : $sched.hashCode());
        Plugin $owner = this.getOwner();
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        Runnable $task = this.getTask();
        result = result * 59 + ($task == null ? 43 : $task.hashCode());
        AtomicBoolean $running = this.getRunning();
        result = result * 59 + ($running == null ? 43 : $running.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BungeeTask(sched=" + this.getSched() + ", id=" + this.getId() + ", owner=" + this.getOwner() + ", task=" + this.getTask() + ", delay=" + this.getDelay() + ", period=" + this.getPeriod() + ", running=" + this.getRunning() + ")";
    }
}

